% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key.R
\name{wmata_key}
\alias{wmata_key}
\alias{wmata_validate}
\title{Find a WMATA API key}
\usage{
wmata_key(api_key = Sys.getenv("WMATA_KEY"))

wmata_validate(api_key = wmata_key())
}
\arguments{
\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
For \code{\link[=wmata_key]{wmata_key()}}, a 32 character alphanumeric API key. For
\code{\link[=wmata_validate]{wmata_validate()}}, either \code{TRUE} for a valid key or an error if invalid.
}
\description{
All calls to the WMATA API must be accompanied by a personal API key. A free
key can be obtained by subscribing to the default tier:
\enumerate{
\item Sign up for a free WMATA developer account: \url{https://developer.wmata.com/}
\item Log in and subscribe to the free default tier.
\item Copy the primary or secondary key from your profile.
\item Pass your API key to a function through one of three ways:
\enumerate{
\item Use \code{\link[=Sys.setenv]{Sys.setenv()}} to temporarily set define \code{WMATA_KEY}.
\item Pass your key as a string to the \code{api_key} argument of any function.
\item Store the the WMATA key as a line like \code{WMATA_KEY=xxxyyyzzz} in your
\code{.Renviron} file, to be called by \code{\link[=wmata_key]{wmata_key()}} via \code{\link[=Sys.getenv]{Sys.getenv()}}.
}
}

The WMATA also provides a demonstration key. This key should \strong{never} be
used in production applications, it is rate limited and subject to change at
\emph{any} time. The key can be found on the WMATA products page when not
signed into a developer account.

The \code{\link[=wmata_validate]{wmata_validate()}} function can be used to verify a key is valid.
}
\details{
Default tier sufficient for most casual developers. Rate limited to 10
calls/second and 50,000 calls per day. This product contains 8 APIs and all
APIs needed for the functions in this package:
\itemize{
\item Bus Route and Stop Methods
\item GTFS (unused)
\item Incidents
\item Misc Methods
\item Rail Station Information
\item Real-Time Bus Predictions
\item Real-Time Rail Predictions
\item Train Positions
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/5923434c08d33c0f201a600a/operations/5923437c031f5914d0204bcf}
}
\concept{Misc Methods}
