% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/residuals.meteDist.R
\name{mseZ}
\alias{mseZ}
\alias{mseZ.meteDist}
\title{Compute z-score of mean squared error}
\usage{
mseZ(x, ...)

\method{mseZ}{meteDist}(x, nrep, return.sim = FALSE, type = c("rank",
  "cumulative"), ...)
}
\arguments{
\item{x}{a \code{meteDist} object}

\item{...}{arguments to be passed to methods}

\item{nrep}{number of simulations from the fitted METE distribution}

\item{return.sim}{logical; return the simulated liklihood values}

\item{type}{either "rank" or "cumulative"}
}
\value{
list with elements
\describe{
   \item{z}{The z-score}
   \item{obs}{Mean squared error}
   \item{sim}{\code{nrep} Simulated values}
}
}
\description{
\code{mseZ.meteDist} Compute z-score of mean squared error
}
\details{
\code{mseZ.meteDist} simulates from a fitted METE distribution (e.g. a species abundance distribution or individual power distribution) and calculates the MSE between the simulated data sets and the METE prediction. The distribution of these values is compared against the MSE of the data to obtain a z-score.
}
\examples{
esf1=meteESF(spp=arth$spp,
              abund=arth$count,
              power=arth$mass^(4/3),
              minE=min(arth$mass^(4/3)))
sad1=sad(esf1)
mseZ(sad1, nrep=100)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
logLik.meteDist
}

