% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA.Algorithm.R
\name{DA}
\alias{DA}
\title{Optimization using Dragonfly Algorithm}
\usage{
DA(FUN, optimType = "MIN", numVar, numPopulation = 40, maxIter = 500,
  rangeVar)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization. 
Otherwise, you can use \code{"MAX"} for maximization problem.}

\item{numVar}{a positive integer to determine the number variable.}

\item{numPopulation}{a positive integer to determine the number population.}

\item{maxIter}{a positive integer to determine the maximum number of iteration.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables, 
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively. 
If all variable have equal upper bound, you can define \code{rangeVar} as 
matrix (\eqn{2 \times 1}).}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable 
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Dragonfly 
Algorithm. It is used to solve continuous optimization tasks. 
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by Mirjalili in 2016. The main inspiration of the 
DA algorithm originates from the static and dynamic swarming behaviours of 
dragonflies in nature. Two essential phases of optimization, exploration and 
exploitation, are designed by modelling the social interaction of dragonflies 
in navigating, searching for foods, and avoiding enemies when swarming 
dynamically or statistically.

In order to find the optimal solution, the algorithm follow the following steps. 
\itemize{
\item Initialization: Initialize the first population of dragonflies randomly, 
      calculate the fitness of dragonflies and find the best dragonfly as
      food source and the worst dragonfly as enemy position.
\item Calculating Behaviour Weight that affecting fly direction and distance.  
      First, find the neighbouring dragonflies for each dragonfly then calculate the behaviour weight. 
      The behaviour weight consist of separation, alignment, cohesion, attracted toward food sources
      and distraction from enemy. The neighbouring dragonfly determined by the neighbouring radius
      that increasing linearly for each iteration.
\item Update the position each dragonfly using behaviour weight and the delta (same as velocity in PSO).
\item Calculate the fitness and update food and enemy position
\item Check termination criteria, if termination criterion is satisfied, return the 
      food position as the optimal solution for given problem. Otherwise, back to Calculating Behaviour Weight steps.
}
}
\examples{
################################## 
## Optimizing the sphere function

# define sphere function as objective function
sphere <- function(X){
    return(sum(X^2))
}

## Define parameter 
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution using Dragonfly Algorithm 
resultDA <- DA(sphere, optimType="MIN", numVar, numPopulation=20, 
                 maxIter=100, rangeVar)

## calculate the optimum value using sphere function
optimum.value <- sphere(resultDA)

}
\references{
Seyedali Mirjalili. 2015. Dragonfly algorithm: a new meta-heuristic optimization 
technique for solving single-objective, discrete, and multi-objective problems. 
Neural Comput. Appl. 27, 4 (May 2015), 1053-1073. 
DOI=https://doi.org/10.1007/s00521-015-1920-1
}
\seealso{
\code{\link{metaOpt}}
}
