% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.MetaForest.R
\name{predict.MetaForest}
\alias{predict.MetaForest}
\title{MetaForest prediction}
\usage{
\method{predict}{MetaForest}(object, data = NULL, type = "response",
  ...)
}
\arguments{
\item{object}{\code{MetaForest} object.}

\item{data}{New test data of class \code{data.frame}.}

\item{type}{Type of prediction. One of 'response', 'se', 'terminalNodes' with default 'response'. See below for details.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Object of class \code{MetaForest.prediction} with elements
  \tabular{ll}{
      \code{predictions}    \tab Predicted classes/values (only for classification and regression)  \cr
      \code{num.trees}   \tab Number of trees. \cr
      \code{num.independent.variables} \tab Number of independent variables. \cr
      \code{treetype}    \tab Type of forest/tree. Classification, regression or survival. \cr
      \code{num.samples}     \tab Number of samples.
  }
}
\description{
MetaForest prediction
}
\examples{
set.seed(56)
data <- SimulateSMD(k_train = 100, model = es * x[,1] * x[,2])
#Conduct fixed-effects MetaForest analysis
mf.fixed <- MetaForest(formula = yi ~ ., data = data$training,
                      whichweights = "fixed", method = "DL")
predicted <- predict(mf.fixed, data = data$testing)$predictions
r2_cv <- sum((predicted - mean(data$training$yi)) ^ 2)/
         sum((data$testing$yi - mean(data$training$yi)) ^ 2)
}
\seealso{
\code{\link[ranger]{ranger}}
}
