% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_documentation.R
\docType{data}
\name{unite_ex_data_1}
\alias{unite_ex_data_1}
\title{Example of UNITE fungal ITS data}
\format{An object of type \code{\link{taxmap}}}
\source{
\url{https://unite.ut.ee/}
}
\usage{
unite_ex_data_1
}
\description{
A dataset containing information from 449 sequences from the UNITE reference database.
}
\examples{
\dontrun{

file_path <- system.file("extdata", "unite_general_release.fasta", package = "metacoder")
sequences <- ape::read.FASTA(file_path)
unite_ex_data_1 <- extract_taxonomy(sequences[!grepl(pattern = "\\\\|UDB", names(sequences))],
                                    regex = "^(.*)\\\\|(.*)\\\\|(.*)\\\\|.*\\\\|(.*)$",
                                    key = c(name = "obs_info", "obs_id",
                                            other_id = "obs_info", tax_string = "obs_info"),
                                    database = "ncbi")
}

}
\keyword{datasets}
