% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{downloadFiles}
\alias{downloadFiles}
\title{Download specific files from a data set}
\usage{
downloadFiles(
  files,
  technique,
  dataSet,
  dataSetDir = "DataSets",
  internalDir = TRUE,
  ask = TRUE,
  ...
)
}
\arguments{
\item{files}{character vector of file paths to download}

\item{technique}{metabolomic technique name}

\item{dataSet}{data set name}

\item{dataSetDir}{directory to store local data sets. If \code{internalDir = TRUE} this is a directory relative to the library location.}

\item{internalDir}{stored the data set internally to the package installation location}

\item{ask}{ask before downloading}

\item{...}{arguments to pass to \code{piggyback::pb_download()}}
}
\value{
A list object containing the API request response results for the downloaded files.
}
\description{
Download specific files for a given example data set.
}
\examples{
\dontrun{
downloadFiles(c('31.mzML.gz','32.mzML.gz'),'FIE-HRMS','BdistachyonTechnical')
}
}
