% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_extraction.R
\name{see_input_data}
\alias{see_input_data}
\title{Overview of effect size measures generated from each type of input data}
\usage{
see_input_data(
  measure = c("all", "d", "g", "md", "or", "rr", "nnt", "r", "z", "logvr", "logcvr",
    "irr"),
  type_of_measure = c("natural+converted", "natural"),
  name = "mcv_input_data",
  extension = c("data.frame", ".txt", ".csv", ".xlsx"),
  verbose = TRUE
)
}
\arguments{
\item{measure}{Target effect size measure (one of the 11 available in metaConvert). Default is "all".}

\item{type_of_measure}{One of "natural+converted" or "natural" (see details).}

\item{name}{Name of the file created}

\item{extension}{Extension of the file created. Most common are ".xlsx", ".csv" or ".txt". It is also possible to generate an R dataframe object by using the "data.frame" extension.}

\item{verbose}{logical variable indicating whether some information should be printed (e.g., the location where the sheet is created when using ".xlsx", ".csv" or ".txt" extensions)}
}
\value{
This function returns a table dataset presenting the input data enabling to
compute each effect size measure.
}
\description{
Overview of effect size measures generated from each type of input data
}
\details{
This function generates, on your computer on in the console,
a dataset showing each effect size measure computed from each type of input data.
The exact combination and names of input data required are available in the links.

The \code{measure} argument allows to filter the dataset created.
Only the input data allowing to estimate the selected effect size measure will be shown. Default is "all".
The \code{type_of_measure} argument allows to filter the dataset created.
\itemize{
\item If "natural+converted" is selected, the dataset will contain all input data allowing to naturally estimate
and to convert the selected effect size measure
\item If "natural" is selected, the dataset will contain all input data allowing to naturally estimate
the selected effect size measure
}
\subsection{Extension}{

You can export a file in various formats outside R
(by indicating, for example, ".txt", ".xlsx", or ".csv") in the \code{extension} argument.
You can also visualise this dataset directly in R by setting \code{extension = "R"}.

This table is designed to be used in combination with tables showing the combination of input data
leading to estimate each of the effect size measures (https://metaconvert.org/html/input.html)
}
}
\examples{
see_input_data(measure = "md", extension = "data.frame")
}
