% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANOVA_means.R
\name{es_from_means_ci}
\alias{es_from_means_ci}
\title{Convert means and 95\% CI of two independent groups several effect size measures}
\usage{
es_from_means_ci(
  mean_exp,
  mean_ci_lo_exp,
  mean_ci_up_exp,
  mean_nexp,
  mean_ci_lo_nexp,
  mean_ci_up_nexp,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_means
)
}
\arguments{
\item{mean_exp}{mean of participants in the experimental/exposed group.}

\item{mean_ci_lo_exp}{lower bound of the 95\% CI of the mean of the experimental/exposed group}

\item{mean_ci_up_exp}{upper bound of the 95\% CI of the mean of the experimental/exposed group}

\item{mean_nexp}{mean of participants in the non-experimental/non-exposed group.}

\item{mean_ci_lo_nexp}{lower bound of the 95\% CI of the mean of the non-experimental/non-exposed group.}

\item{mean_ci_up_nexp}{upper bound of the 95\% CI of the mean of the non-experimental/non-exposed group.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_means}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 9. Means and dispersion (crude)'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert means and 95\% CI of two independent groups several effect size measures
}
\details{
This function converts the 95\% CI of two independent groups into a standard error,
and then relies on the calculations of the \code{\link{es_from_means_se}()} function.

\strong{To convert the 95\% CIs into standard errors,} the following formula is used (table 12.3 in Cooper):
\deqn{mean\_se\_exp = \frac{mean\_ci\_up\_exp - mean\_ci\_lo\_exp}{2 * qt{(0.975, df = n\_exp - 1)}}}
\deqn{mean\_se\_nexp = \frac{mean\_ci\_up\_nexp - mean\_ci\_lo\_nexp}{2 * qt{(0.975, df = n\_nexp - 1)}}}
Calculations of the \code{\link{es_from_means_se}()} are then applied.
}
\examples{
es_from_means_ci(
  n_exp = 55, n_nexp = 55,
  mean_exp = 25, mean_ci_lo_exp = 15, mean_ci_up_exp = 35,
  mean_nexp = 18, mean_ci_lo_nexp = 12, mean_ci_up_nexp = 24
)
}
\references{
Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect size measures and computing estimates of effect. In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
