% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ETASQ.R
\name{es_from_etasq}
\alias{es_from_etasq}
\title{Convert an eta-squared value to various effect size measures}
\usage{
es_from_etasq(etasq, n_exp, n_nexp, smd_to_cor = "viechtbauer", reverse_etasq)
}
\arguments{
\item{etasq}{an eta-squared value (binary predictor, ANOVA model))}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation.}

\item{reverse_etasq}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 11. ANOVA statistics, Student's t-test, or point-bis correlation'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert an eta-squared value to various effect size measures
}
\details{
This function first computes a Cohen's d (D) and Hedges' g (G)
from the eta squared of a binary predictor (ANOVA model).
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{To estimate a Cohen's d} the following formula is used (Cohen, 1988):
\deqn{d = 2 * \sqrt{\frac{etasq}{1 - etasq}}}

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.
}
\examples{
es_from_etasq(etasq = 0.28, n_exp = 20, n_nexp = 22)
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences. Routledge.
}
