% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagen.R
\name{metagen}
\alias{metagen}
\title{Generic inverse variance meta-analysis}
\usage{
metagen(TE, seTE, studlab, data = NULL, subset = NULL,
  exclude = NULL, sm = "", level = gs("level"),
  level.comb = gs("level.comb"), comb.fixed = gs("comb.fixed"),
  comb.random = gs("comb.random"), hakn = gs("hakn"),
  method.tau = gs("method.tau"), tau.preset = NULL, TE.tau = NULL,
  tau.common = gs("tau.common"), prediction = gs("prediction"),
  level.predict = gs("level.predict"), null.effect = 0,
  method.bias = gs("method.bias"), n.e = NULL, n.c = NULL, pval, df,
  lower, upper, level.ci = 0.95, median, q1, q3, min, max, approx.TE,
  approx.seTE, backtransf = gs("backtransf"), pscale = 1,
  irscale = 1, irunit = "person-years", title = gs("title"),
  complab = gs("complab"), outclab = "", label.e = gs("label.e"),
  label.c = gs("label.c"), label.left = gs("label.left"),
  label.right = gs("label.right"), byvar, bylab,
  print.byvar = gs("print.byvar"), byseparator = gs("byseparator"),
  keepdata = gs("keepdata"), warn = gs("warn"), control = NULL)
}
\arguments{
\item{TE}{Estimate of treatment effect, e.g., log hazard ratio or
risk difference.}

\item{seTE}{Standard error of treatment estimate.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots.}

\item{sm}{A character string indicating underlying summary measure,
e.g., \code{"RD"}, \code{"RR"}, \code{"OR"}, \code{"ASD"},
\code{"HR"}, \code{"MD"}, \code{"SMD"}, or \code{"ROM"}.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{level.comb}{The level used to calculate confidence intervals
for pooled estimates.}

\item{comb.fixed}{A logical indicating whether a fixed effect
meta-analysis should be conducted.}

\item{comb.random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{hakn}{A logical indicating whether method by Hartung and
Knapp should be used to adjust test statistics and confidence
intervals.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2}. Either
\code{"DL"}, \code{"PM"}, \code{"REML"}, \code{"ML"},
\code{"HS"}, \code{"SJ"}, \code{"HE"}, or \code{"EB"}, can be
abbreviated.}

\item{tau.preset}{Prespecified value for the square-root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{null.effect}{A numeric value specifying the effect under the
null hypothesis.}

\item{method.bias}{A character string indicating which test is to
be used.  Either \code{"rank"}, \code{"linreg"}, or \code{"mm"},
can be abbreviated.  See function \code{\link{metabias}}}

\item{n.e}{Number of observations in experimental group.}

\item{n.c}{Number of observations in control group.}

\item{pval}{P-value (used to estimate the standard error).}

\item{df}{Degrees of freedom (used in test or to construct
confidence interval).}

\item{lower}{Lower limit of confidence interval (used to estimate
the standard error).}

\item{upper}{Upper limit of confidence interval (used to estimate
the standard error).}

\item{level.ci}{Level of confidence interval.}

\item{median}{Median (used to estimate the treatment effect and
standard error).}

\item{q1}{First quartile (used to estimate the treatment effect and
standard error).}

\item{q3}{Third quartile (used to estimate the treatment effect and
standard error).}

\item{min}{Minimum (used to estimate the treatment effect and
standard error).}

\item{max}{Maximum (used to estimate the treatment effect and
standard error).}

\item{approx.TE}{Approximation method to estimate treatment
estimate (see Details).}

\item{approx.seTE}{Approximation method to estimate standard error
(see Details).}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If \code{backtransf =
TRUE} (default), results for \code{sm = "OR"} are printed as odds
ratios rather than log odds ratios and results for \code{sm =
"ZCOR"} are printed as correlations rather than Fisher's z
transformed correlations, for example.}

\item{pscale}{A numeric giving scaling factor for printing of
single event probabilities or risk differences, i.e. if argument
\code{sm} is equal to \code{"PLOGIT"}, \code{"PLN"},
\code{"PRAW"}, \code{"PAS"}, \code{"PFT"}, or \code{"RD"}.}

\item{irscale}{A numeric defining a scaling factor for printing of
single incidence rates or incidence rate differences, i.e. if
argument \code{sm} is equal to \code{"IR"}, \code{"IRLN"},
\code{"IRS"}, \code{"IRFT"}, or \code{"IRD"}.}

\item{irunit}{A character specifying the time unit used to
calculate rates, e.g. person-years.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{label.e}{Label for experimental group.}

\item{label.c}{Label for control group.}

\item{label.left}{Graph label on left side of forest plot.}

\item{label.right}{Graph label on right side of forest plot.}

\item{byvar}{An optional vector containing grouping information
(must be of same length as \code{TE}).}

\item{bylab}{A character string with a label for the grouping
variable.}

\item{print.byvar}{A logical indicating whether the name of the
grouping variable should be printed in front of the group labels.}

\item{byseparator}{A character string defining the separator
between label and levels of grouping variable.}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if studies are excluded from meta-analysis due to zero
standard errors).}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance tau^2. This argument is
passed on to \code{\link[metafor]{rma.uni}}.}
}
\value{
An object of class \code{c("metagen", "meta")} with corresponding
\code{print}, \code{summary}, and \code{forest} functions. The
object is a list containing the following components:
\item{TE, seTE, studlab, exclude, n.e, n.c}{As defined above.}
\item{sm, level, level.comb,}{As defined above.}
\item{comb.fixed, comb.random,}{As defined above.}
\item{hakn, method.tau, tau.preset, TE.tau, method.bias,}{As
  defined above.}
\item{tau.common, title, complab, outclab,}{As defined above.}
\item{label.e, label.c, label.left, label.right,}{As defined
  above.}
\item{byvar, bylab, print.byvar, byseparator, warn}{As defined
  above.}
\item{lower, upper}{Lower and upper confidence interval limits for
  individual studies.}
\item{zval, pval}{z-value and p-value for test of treatment effect
  for individual studies.}
\item{w.fixed, w.random}{Weight of individual studies (in fixed and
  random effects model).}
\item{TE.fixed, seTE.fixed}{Estimated overall treatment effect and
  standard error (fixed effect model).}
\item{lower.fixed, upper.fixed}{Lower and upper confidence interval
  limits (fixed effect model).}
\item{zval.fixed, pval.fixed}{z-value and p-value for test of
  overall treatment effect (fixed effect model).}
\item{TE.random, seTE.random}{Estimated overall treatment effect
  and standard error (random effects model).}
\item{lower.random, upper.random}{Lower and upper confidence
  interval limits (random effects model).}
\item{zval.random, pval.random}{z-value or t-value and
  corresponding p-value for test of overall treatment effect
  (random effects model).}
\item{prediction, level.predict}{As defined above.}
\item{seTE.predict}{Standard error utilised for prediction
  interval.}
\item{lower.predict, upper.predict}{Lower and upper limits of
  prediction interval.}
\item{null.effect}{As defined above.}
\item{k}{Number of studies combined in meta-analysis.}
\item{Q}{Heterogeneity statistic.}
\item{df.Q}{Degrees of freedom for heterogeneity statistic.}
\item{pval.Q}{P-value of heterogeneity test.}
\item{tau}{Square-root of between-study variance.}
\item{se.tau2}{Standard error of between-study variance.}
\item{C}{Scaling factor utilised internally to
  calculate common tau-squared across subgroups.}
\item{method}{Pooling method: \code{"Inverse"}.}
\item{df.hakn}{Degrees of freedom for test of treatment effect for
  Hartung-Knapp method (only if \code{hakn = TRUE}).}
\item{bylevs}{Levels of grouping variable - if \code{byvar} is not
  missing.}
\item{TE.fixed.w, seTE.fixed.w}{Estimated treatment effect and
  standard error in subgroups (fixed effect model) - if
  \code{byvar} is not missing.}
\item{lower.fixed.w, upper.fixed.w}{Lower and upper confidence
  interval limits in subgroups (fixed effect model) - if
  \code{byvar} is not missing.}
\item{zval.fixed.w, pval.fixed.w}{z-value and p-value for test of
  treatment effect in subgroups (fixed effect model) - if
  \code{byvar} is not missing.}
\item{TE.random.w, seTE.random.w}{Estimated treatment effect and
  standard error in subgroups (random effects model) - if
  \code{byvar} is not missing.}
\item{lower.random.w, upper.random.w}{Lower and upper confidence
  interval limits in subgroups (random effects model) - if
  \code{byvar} is not missing.}
\item{zval.random.w, pval.random.w}{z-value or t-value and
  corresponding p-value for test of treatment effect in subgroups
  (random effects model) - if \code{byvar} is not missing.}
\item{w.fixed.w, w.random.w}{Weight of subgroups (in fixed and
  random effects model) - if \code{byvar} is not missing.}
\item{df.hakn.w}{Degrees of freedom for test of treatment effect
  for Hartung-Knapp method in subgroups - if \code{byvar} is not
  missing and \code{hakn = TRUE}.}
\item{n.harmonic.mean.w}{Harmonic mean of number of observations in
  subgroups (for back transformation of Freeman-Tukey Double
  arcsine transformation) - if \code{byvar} is not missing.}
\item{n.e.w}{Number of observations in experimental group in
  subgroups - if \code{byvar} is not missing.}
\item{n.c.w}{Number of observations in control group in subgroups -
  if \code{byvar} is not missing.}
\item{k.w}{Number of studies combined within
  subgroups - if \code{byvar} is not missing.}
\item{k.all.w}{Number of all studies in subgroups - if \code{byvar}
  is not missing.}
\item{Q.w.fixed}{Overall within subgroups heterogeneity statistic Q
  (based on fixed effect model) - if \code{byvar} is not missing.}
\item{Q.w.random}{Overall within subgroups heterogeneity statistic
  Q (based on random effects model) - if \code{byvar} is not
  missing (only calculated if argument \code{tau.common} is TRUE).}
\item{df.Q.w}{Degrees of freedom for test of overall within
  subgroups heterogeneity - if \code{byvar} is not missing.}
\item{pval.Q.w.fixed}{P-value of within subgroups heterogeneity
  statistic Q (based on fixed effect model) - if \code{byvar} is
  not missing.}
\item{pval.Q.w.random}{P-value of within subgroups heterogeneity
  statistic Q (based on random effects model) - if \code{byvar} is
  not missing.}
\item{Q.b.fixed}{Overall between subgroups heterogeneity statistic
  Q (based on fixed effect model) - if \code{byvar} is not
  missing.}
\item{Q.b.random}{Overall between subgroups heterogeneity statistic
  Q (based on random effects model) - if \code{byvar} is not
  missing.}
\item{df.Q.b}{Degrees of freedom for test of overall between
  subgroups heterogeneity - if \code{byvar} is not missing.}
\item{pval.Q.b.fixed}{P-value of between subgroups heterogeneity
  statistic Q (based on fixed effect model) - if \code{byvar} is
  not missing.}  \item{pval.Q.b.random}{P-value of between
  subgroups heterogeneity statistic Q (based on random effects
  model) - if \code{byvar} is not missing.}
\item{tau.w}{Square-root of between-study variance within subgroups
  - if \code{byvar} is not missing.}  \item{C.w}{Scaling factor
  utilised internally to calculate common tau-squared across
  subgroups - if \code{byvar} is not missing.}
  \item{H.w}{Heterogeneity statistic H within subgroups - if
  \code{byvar} is not missing.}
\item{lower.H.w, upper.H.w}{Lower and upper confidence limti for
  heterogeneity statistic H within subgroups - if \code{byvar} is
  not missing.}  \item{I2.w}{Heterogeneity statistic I2 within
  subgroups - if \code{byvar} is not missing.}
\item{lower.I2.w, upper.I2.w}{Lower and upper confidence limti for
  heterogeneity statistic I2 within subgroups - if \code{byvar} is
  not missing.}
\item{keepdata}{As defined above.}
\item{data}{Original data (set) used in function call (if
  \code{keepdata = TRUE}).}
\item{subset}{Information on subset of original data used in
  meta-analysis (if \code{keepdata = TRUE}).}
\item{call}{Function call.}
\item{version}{Version of R package \bold{meta} used to create
  object.}
}
\description{
Fixed effect and random effects meta-analysis based on estimates
(e.g. log hazard ratios) and their standard errors. The inverse
variance method is used for pooling.
}
\details{
This function provides the \emph{generic inverse variance method}
for meta-analysis which requires treatment estimates and their
standard errors (Borenstein et al., 2010). The method is useful,
e.g., for pooling of survival data (using log hazard ratio and
standard errors as input). Arguments \code{TE} and \code{seTE} can
be used to provide treatment estimates and standard errors
directly. However, it is possible to derive these quantities from
other information.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

\subsection{Approximate treatment estimates}{

Missing treatment estimates can be derived from
\enumerate{
\item confidence limits provided by arguments \code{lower} and
  \code{upper};
\item median, interquartile range and range (arguments
  \code{median}, \code{q1}, \code{q3}, \code{min}, and \code{max});
\item median and interquartile range (arguments \code{median},
  \code{q1} and \code{q3});
\item median and range (arguments \code{median}, \code{min} and
  \code{max}).
}
For confidence limits, the treatment estimate is defined as the
center of the confidence interval (on the log scale for relative
effect measures like the odds ratio or hazard ratio). For median,
interquartile range and range, equation (10) in Wan et al. (2014)
is used to approximate the treatment effect (i.e.,
mean). Similarly, equations (14) and (2) in Wan et al. (2014) are
used if median and interquartile range or range, respectively, are
provided.

By default, missing treatment estimates are replaced successively
using these method, e.g., confidence limits are utilised before
interquartile ranges. Argument \code{approx.TE} can be used to
overwrite this default for each individual study:
\itemize{
\item Use treatment estimate directly (entry \code{""} in argument
  \code{approx.TE});
\item confidence limits (\code{"ci"} in argument \code{approx.TE});
\item median, interquartile range and range (\code{"iqr.range"});
\item median and interquartile range (\code{"iqr"});
\item median and range (\code{"range"}).
}
}

\subsection{Approximate standard errors}{

Missing standard errors can be derived from
\enumerate{
\item p-value provided by arguments \code{pval} and (optional)
  \code{df};
\item confidence limits (arguments \code{lower}, \code{upper}, and
  (optional) \code{df});
\item sample size, median, interquartile range and range (arguments
  \code{n.e} and / or \code{n.c}, \code{median}, \code{q1},
  \code{q3}, \code{min}, and \code{max});
\item sample size, median and interquartile range (arguments
  \code{n.e} and / or \code{n.c}, \code{median}, \code{q1} and
  \code{q3});
\item sample size, median and range (arguments \code{n.e} and / or
  \code{n.c}, \code{median}, \code{min} and \code{max}).
}
For p-values and confidence limits, calculations are either based
on the standard normal or \emph{t} distribution if argument
\code{df} is provided. Furthermore, argument \code{level.ci} can be
used to provide the level of the confidence interval. For median,
interquartile range and range, depending on the sample size,
equation (12) or (13) in Wan et al. (2014) is used to approximate
the standard error. Similarly, equations (15) / (16) and (7) / (9)
in Wan et al. (2014) are used if median and interquartile range or
range, respectively, are provided. The sample size of individual
studies must be provided with arguments \code{n.e} and / or
\code{n.c}. The total sample size is calculated as \code{n.e} +
\code{n.c} if both arguments are provided.

By default, missing standard errors are replaced successively using
these method, e.g., p-value before confidence limits before
interquartile range and range. Argument \code{approx.seTE} can be
used to overwrite this default for each individual study:

\itemize{
\item Use standard error directly (entry \code{""} in argument
  \code{approx.seTE});
\item p-value (\code{"pval"} in argument \code{approx.seTE});
\item confidence limits (\code{"ci"});
\item median, interquartile range and range (\code{"iqr.range"});
\item median and interquartile range (\code{"iqr"});
\item median and range (\code{"range"}).
}
}

\subsection{Estimation of between-study variance}{

The following methods are available to estimate the between-study
variance \eqn{\tau^2}.
\tabular{ll}{
\bold{Argument}\tab \bold{Method} \cr 
\code{method.tau = "DL"}\tab DerSimonian-Laird estimator (DerSimonian and Laird, 1986) \cr
\code{method.tau = "PM"}\tab Paule-Mandel estimator (Paule and Mandel, 1982) \cr
\code{method.tau = "REML"}\tab Restricted maximum-likelihood estimator (Viechtbauer, 2005) \cr
\code{method.tau = "ML"}\tab Maximum-likelihood estimator (Viechtbauer, 2005) \cr
\code{method.tau = "HS"}\tab Hunter-Schmidt estimator (Hunter and Schmidt, 2015) \cr
\code{method.tau = "SJ"}\tab Sidik-Jonkman estimator (Sidik and Jonkman, 2005) \cr
\code{method.tau = "HE"}\tab Hedges estimator (Hedges and Olkin, 1985) \cr
\code{method.tau = "EB"}\tab Empirical Bayes estimator (Morris, 1983)
}

Historically, the DerSimonian-Laird method was the de facto
standard to estimate the between-study variance \eqn{\tau^2} and is
still the default in many software packages including Review
Manager 5 (RevMan 5) and R package \pkg{meta}. However, its role
has been challenged and especially the Paule-Mandel and REML
estimators have been recommended (Veroniki et al.,
2016). Accordingly, the following R command can be used to use the
Paule-Mandel estimator in all meta-analyses of the R session:
\code{settings.meta(method.tau = "PM")}

The DerSimonian-Laird and Paule-Mandel estimators are implemented
in R package \pkg{meta}. R function \code{\link[metafor]{rma.uni}}
from R package \pkg{metafor} (Viechtbauer 2010) is called
internally for the other estimators.
}

\subsection{Hartung-Knapp method}{

Hartung and Knapp (2001a,b) proposed an alternative method for
random effects meta-analysis based on a refined variance estimator
for the treatment estimate. Simulation studies (Hartung and Knapp,
2001a,b; IntHout et al., 2014; Langan et al., 2019) show improved
coverage probabilities compared to the classic random effects
method. However, in rare settings with very homogeneous treatment
estimates, the Hartung-Knapp method can be anti-conservative
(Wiksten et al., 2016). The Hartung-Knapp method is used if
argument \code{hakn = TRUE}.
}

\subsection{Prediction interval}{

A prediction interval for the treatment effect of a new study
(Higgins et al., 2009) is calculated if arguments \code{prediction}
and \code{comb.random} are \code{TRUE}. Note, the definition of
prediction intervals varies in the literature. This function
implements equation (12) of Higgins et al., (2009) which proposed a
\emph{t} distribution with \emph{K-2} degrees of freedom where
\emph{K} corresponds to the number of studies in the meta-analysis.
}

\subsection{Subgroup analysis}{

Argument \code{byvar} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Specify the null hypothesis of test for an overall effect}{

Argument \code{null.effect} can be used to specify the (treatment)
effect under the null hypothesis in a test for an overall
effect.

By default (\code{null.effect = 0}), the null hypothesis
corresponds to "no difference" (which is obvious for absolute
effect measures like the mean difference (\code{sm = "MD"}) or
standardised mean difference (\code{sm = "SMD"})). For relative
effect measures, e.g., risk ratio (\code{sm = "RR"}) or odds ratio
(\code{sm = "OR"}), the null effect is defined on the log scale,
i.e., \emph{ln}(RR) = 0 or \emph{ln}(OR) = 0 which is equivalent to
testing RR = 1 or OR = 1.

Use of argument \code{null.effect} is especially useful for summary
measures without a "natural" null effect, i.e., in situations
without a second (treatment) group. For example, an overall
proportion of 50\% could be tested in the meta-analysis of single
proportions with argument \code{null.effect = 0.5}.

Note, all tests for an overall effect are two-sided with the
alternative hypothesis that the effect is unequal to
\code{null.effect}.
}

\subsection{Presentation of meta-analysis results}{

Internally, both fixed effect and random effects models are
calculated regardless of values choosen for arguments
\code{comb.fixed} and \code{comb.random}. Accordingly, the estimate
for the random effects model can be extracted from component
\code{TE.random} of an object of class \code{"meta"} even if
argument \code{comb.random = FALSE}. However, all functions in R
package \bold{meta} will adequately consider the values for
\code{comb.fixed} and \code{comb.random}. For example, functions
\code{\link{print.meta}} and \code{\link{forest.meta}} will not
show results for the random effects model if \code{comb.random =
FALSE}.

Argument \code{pscale} can be used to rescale single proportions or
risk differences, e.g. \code{pscale = 1000} means that proportions
are expressed as events per 1000 observations. This is useful in
situations with (very) low event probabilities.

Argument \code{irscale} can be used to rescale single rates or rate
differences, e.g. \code{irscale = 1000} means that rates are
expressed as events per 1000 time units, e.g. person-years. This is
useful in situations with (very) low rates. Argument \code{irunit}
can be used to specify the time unit used in individual studies
(default: "person-years"). This information is printed in summaries
and forest plots if argument \code{irscale} is not equal to 1.

Default settings for \code{comb.fixed}, \code{comb.random},
\code{pscale}, \code{irscale}, \code{irunit} and several other
arguments can be set for the whole R session using
\code{\link{settings.meta}}.
}
}
\examples{
data(Fleiss93)
m1 <- metabin(event.e, n.e, event.c, n.c,
              data = Fleiss93, sm = "RR", method = "I")
m1
# Identical results by using the generic inverse variance method
metagen(m1$TE, m1$seTE, sm = "RR")
#
forest(metagen(m1$TE, m1$seTE, sm = "RR"))


# Meta-analysis with prespecified between-study variance
#
summary(metagen(m1$TE, m1$seTE, sm = "RR", tau.preset = sqrt(0.1)))


# Meta-analysis of survival data:
#
logHR <- log(c(0.95, 1.5))
selogHR <- c(0.25, 0.35)
metagen(logHR, selogHR, sm = "HR")


# Paule-Mandel method to estimate between-study variance for data
# from Paule & Mandel (1982)
#
average <- c(27.044, 26.022, 26.340, 26.787, 26.796)
variance <- c(0.003, 0.076, 0.464, 0.003, 0.014)
#
summary(metagen(average, sqrt(variance), sm = "MD", method.tau = "PM"))


# Conduct meta-analysis using hazard ratios and 95\% confidence intervals
#
# Data from Steurer et al. (2006), Analysis 1.1 Overall survival
# https://www.cochranelibrary.com/cdsr/doi/10.1002/14651858.CD004270.pub2/abstract
#
study <- c("FCG on CLL 1996", "Leporrier 2001", "Rai 2000", "Robak 2000")
HR <- c(0.55, 0.92, 0.79, 1.18)
lower.HR <- c(0.28, 0.79, 0.59, 0.64)
upper.HR <- c(1.09, 1.08, 1.05, 2.17)
#
# Input must be log hazard ratios, not hazard ratios
#
metagen(log(HR), lower = log(lower.HR), upper = log(upper.HR),
        studlab = study, sm = "HR")

}
\references{
Borenstein M, Hedges LV, Higgins JP, Rothstein HR (2010):
A basic introduction to fixed-effect and random-effects models for
meta-analysis.
\emph{Research Synthesis Methods},
\bold{1}, 97--111

Cooper H & Hedges LV (1994):
\emph{The Handbook of Research Synthesis}.
Newbury Park, CA: Russell Sage Foundation

DerSimonian R & Laird N (1986):
Meta-analysis in clinical trials.
\emph{Controlled Clinical Trials},
\bold{7}, 177--88

Hedges LV & Olkin I (1985):
\emph{Statistical methods for meta-analysis}.
San Diego, CA: Academic Press

Higgins JPT, Thompson SG, Spiegelhalter DJ (2009):
A re-evaluation of random-effects meta-analysis.
\emph{Journal of the Royal Statistical Society: Series A},
\bold{172}, 137--59

Hunter JE & Schmidt FL (2015):
\emph{Methods of Meta-Analysis: Correcting Error and Bias in
Research Findings} (Third edition).
Thousand Oaks, CA: Sage

Hartung J, Knapp G (2001a):
On tests of the overall treatment effect in meta-analysis with
normally distributed responses.
\emph{Statistics in Medicine},
\bold{20}, 1771--82

Hartung J, Knapp G (2001b):
A refined method for the meta-analysis of controlled clinical
trials with binary outcome.
\emph{Statistics in Medicine},
\bold{20}, 3875--89

IntHout J, Ioannidis JPA, Borm GF (2014):
The Hartung-Knapp-Sidik-Jonkman method for random effects
meta-analysis is straightforward and considerably outperforms the
standard DerSimonian-Laird method.
\emph{BMC Medical Research Methodology},
\bold{14}, 25

Langan D, Higgins JPT, Jackson D, Bowden J, Veroniki AA,
Kontopantelis E, et al. (2019):
A comparison of heterogeneity variance estimators in simulated
random-effects meta-analyses.
\emph{Research Synthesis Methods},
\bold{10}, 83--98

Morris CN (1983):
Parametric empirical Bayes inference: Theory and applications (with
discussion).
\emph{Journal of the American Statistical Association}
\bold{78}, 47--65

Paule RC & Mandel J (1982):
Consensus values and weighting factors.
\emph{Journal of Research of the National Bureau of Standards},
\bold{87}, 377--85

\emph{Review Manager (RevMan)} [Computer program]. Version 5.3.
Copenhagen: The Nordic Cochrane Centre, The Cochrane Collaboration, 2014

Sidik K & Jonkman JN (2005):
Simple heterogeneity variance estimation for meta-analysis.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)},
\bold{54}, 367--84

Veroniki AA, Jackson D, Viechtbauer W, Bender R, Bowden J, Knapp G,
et al. (2016):
Methods to estimate the between-study variance and its uncertainty
in meta-analysis.
\emph{Research Synthesis Methods},
\bold{7}, 55--79 

Viechtbauer W (2005):
Bias and efficiency of meta-analytic variance estimators in the
random-effects model.
\emph{Journal of Educational and Behavioral Statistics},
\bold{30}, 261--93

Viechtbauer W (2010):
Conducting Meta-Analyses in R with the metafor Package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48

Wan X, Wang W, Liu J, Tong T (2014):
Estimating the sample mean and standard deviation from the sample
size, median, range and/or interquartile range.
\emph{BMC Medical Research Methodology},
\bold{14}, 135

Wiksten A, Rücker G, Schwarzer G (2016):
Hartung-Knapp method is not always conservative compared with
fixed-effect meta-analysis.
\emph{Statistics in Medicine},
\bold{35}, 2503--15
}
\seealso{
\code{\link{update.meta}}, \code{\link{metabin}},
  \code{\link{metacont}}, \code{\link{print.meta}},
  \code{\link{settings.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
