% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_funs.R
\name{logic}
\alias{logic}
\alias{\%~\%}
\alias{Similar}
\title{Extended logical operators}
\usage{
x \%~\% target

Similar(x, target, tol = Inf)
}
\arguments{
\item{x, target}{numeric vectors}

\item{tol}{tolerance for similarity}
}
\value{
A logical vector of the same length of x.
}
\description{
Extended binary operators for easy subsetting.
}
\details{
\code{\%~\%} can be thought as a "similar" operator. It's a fuzzy version of
\code{\link{\%in\%}} in that returns \code{TRUE} for the element of \code{x}
which is the (first) closest to any element of \code{target}.

\code{Similar} is a functional version of \code{\%~\%} that also has a
\code{tol} parameter that indicates the maximum allowed tolerance.
}
\examples{
set.seed(198)
x <- rnorm(100)
x[x \%~\% c(0.3, 0.5, 1)]

# Practical use case: vertical cross-section at
# approximately 36W between 50S and 50N.
cross.lon <- -34 + 360
library(ggplot2)
library(data.table)
ggplot(temperature[lon \%~\% cross.lon & lat \%between\% c(-50, 50)],
       aes(lat, lev)) +
    geom_contour(aes(z = air))

}
\seealso{
Other utilities: 
\code{\link{Anomaly}()},
\code{\link{JumpBy}()},
\code{\link{Mag}()},
\code{\link{Percentile}()}
}
\concept{utilities}
