% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplification.R
\name{plot.mesh.2.5D}
\alias{plot.mesh.2.5D}
\title{Plot a mesh in a 3D perspective.}
\usage{
\method{plot}{mesh.2.5D}(x, loc = NULL, phi = 40, theta = 40, ...)
}
\arguments{
\item{x}{An object of class \code{mesh.2.5D}, representing the mesh to plot.}

\item{loc}{#data-by-3 matrix collecting the locations of data points over the mesh.
Default is NULL, i.e. the data points are assumed to coincide with the mesh vertices.}

\item{phi}{Colatitude (in degrees) identifying the viewing direction; default is 40.}

\item{theta}{Longitude (in degrees) identifying the viewing direction; default is 40.}

\item{...}{Additional arguments passed to the plotting methods; these include:
xlim, ylim, zlim, xlab, ylab, zlab, main, sub, r, d, scale, expand, box, axes, nticks, ticktype.}
}
\description{
Plot a 2.5D surface mesh augmented with associated data locations. The package \pkg{plot3D} is used.
}
\examples{
## Import the mesh of a pawn
 data(pawn_250)
## Plot the original mesh
plot.mesh.2.5D(mesh, main = "Original mesh, 250 nodes")
## Simplify the mesh down to 200 nodes; assume the components of the
## edge cost functions are equally weighted and that the data locations
## coincide with the vertices of the mesh
out <- simplify.mesh.2.5D(mesh, 200)
## Plot the simplified mesh
plot.mesh.2.5D(out$mesh, loc = out$locations, main = "Simplified mesh, 200 nodes")
}
\seealso{
\code{\link{simplify.mesh.2.5D}}
}
