% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplification.R
\name{import.mesh.2.5D}
\alias{import.mesh.2.5D}
\title{Instantiate a \code{mesh.2.5D} object from file.}
\usage{
import.mesh.2.5D(file)
}
\arguments{
\item{file}{Absolute or relative path to the input mesh; the following file formats are supported:
\itemize{
    \item AVS UCD ASCII (extension .inp);
    \item text files (extension .txt);
    \item Legacy VTK (extension .vtk).
}
Text files are assumed to be structured as the AVS UCD ASCII files (.inp extension).}
}
\value{
An object of class \code{mesh.2.5D}, provided with the following attributes:
				\itemize{
					\item \code{nnodes}: number of nodes in the mesh;
					\item \code{nodes}: \code{nnodes}-by-3 matrix collecting the coordinates of each vertex;
					\item \code{ntriangles}: number of triangles in the mesh;
					\item \code{triangles}: a \code{ntriangles}-by-3 (when \code{order} = 1) or \code{ntriangles}-by-6 (when \code{order} = 2) matrix. It specifies the triangles giving the row indices in \code{nodes} of the triangles vertices and (when \code{order} = 2) also of the triangles edges midpoints;
					\item \code{order}: either '1' or '2'. It specifies whether each mesh triangle should be represented by \eqn{3} nodes (the triangle vertices) or by \eqn{6} nodes (the triangle vertices and midpoints of the triangle edges). These are respectively used for linear (\code{order} = 1) and quadratic (\code{order} = 2) Finite Elements. Default is \code{order} = 1.
				}
}
\description{
This function reads a surface mesh from file, and returns an object of class \code{mesh.2.5D} holding the list of nodes and triangles in the mesh. The parsing of the file is carried out at the C++ level for the sake of efficiency.
}
\examples{
## Import the mesh of a pawn
fpath <- system.file("extdata", "pawn_250.inp", package="meshsimp")
mesh <- import.mesh.2.5D(fpath)
## Simplify the mesh down to 200 nodes; assume the components of the
## edge cost functions are equally weighted and that the data locations
## coincide with the vertices of the mesh
out1 <- simplify.mesh.2.5D(mesh, 200)
## Resume the simplification procedure, reducing the mesh down to 150 nodes
out2 <- simplify.mesh.2.5D(out1$mesh, 150, out1$locations)
}
\seealso{
\code{\link{simplify.mesh.2.5D}}, \code{\link{plot.mesh.2.5D}}
}
