\name{bucket}
\alias{bucket}
\alias{default_bucket}
\alias{put_into}
\alias{put_into.default_bucket}
\alias{dim.default_bucket}
\alias{as.data.frame.default_bucket}
\alias{as.matrix.default_bucket}
\alias{as.data.frame.default_bucket}
\alias{print.bucket}
\alias{pour_out}
\alias{pour_out.default_bucket}
\alias{textfile_bucket}
\alias{put_into.textfile_bucket}
\alias{pour_out.textfile_bucket}
\alias{dim.textfile_bucket}
\alias{as.data.frame.textfile_bucket}
\alias{as.matrix.textfile_bucket}
\alias{[.bucket}
\title{Abstract Data Structures to Collect Simulation Results}
\description{
  Buckets (objects that inherit from S3 class "bucket") are abstract data
  structures that are internally used by function \code{Simulate} to collect
  results from individual replications of a simulation study.
}
\usage{
# Generic functions used by 'Simulate'
put_into(bucket,value)
pour_out(bucket,...)

# This generates a bucket that puts data
# into a data frame
default_bucket(size=1)

\method{put_into}{default_bucket}(bucket,value)
\method{pour_out}{default_bucket}(bucket,...)
\method{dim}{default_bucket}(x)
\method{as.matrix}{default_bucket}(x,...)
\method{as.data.frame}{default_bucket}(x,...)

# This generates a bucket that puts data
# into a text file.
textfile_bucket(size=1,name=date())
\method{put_into}{textfile_bucket}(bucket,value)
\method{pour_out}{textfile_bucket}(bucket,...)
\method{dim}{textfile_bucket}(x)
\method{as.data.frame}{textfile_bucket}(x,...)
\method{as.matrix}{textfile_bucket}(x,...)

\method{print}{bucket}(x,...)
\method{[}{bucket}(x,i,...)
}
\arguments{
  \item{bucket,x,data}{an object that inherits from class "bucket".}
  \item{value}{a named list of results of a replication to put into the bucket.}
  \item{size}{a numerical value, the number of rows by which to extend
        the bucket if it is full. This will be set by \code{\link{Simulate}}
        either according to its \code{nsim} argument or according
        to \code{getOption("Simulation.chunk.size")}}
  \item{name}{a name for the textfile into which results are written.}
  \item{i}{a numerical vector to select replication results from the bucket.}
  \item{\dots}{other arguments, ignored or passed to other methods.}
}
\details{
If a user wants to provide another class of buckets for
collecting results for 'Simulate' (s)he needs to
define a function that returns a bucket object, as
\code{default_bucket} and \code{textfile_bucket} do;
and to define methods of \code{put_into}, \code{pour_out},
\code{dim}, \code{as.data.frame}, \code{as.matrix} for
the newly defined bucket class.

The \code{put_into} method should add a list of values to the bucket,
the \code{pour_out} method should close the bucket
against further input and pour
out in the data contained in the bucket into a fixed data structure.
After \code{pour_out}, \code{put_into} should fail.
The \code{default_bucket} method, e.g. puts the data into a data frame,
the \code{textfile_bucket} method closes the textfile into which
data were written.
}
\value{
  The function \code{default_bucket} returns
  an object of class \code{"default_bucket"},
  while function \code{textfile_bucket} returns
  an object of class \code{"textfile_bucket"}.

  The methods for \code{dim}, \code{as.data.frame},
  and \code{as.matrix} give the usual return values,
  of the generic functions.

  \code{put_into} returns nothing.
  \code{pour_out} returns the bucket.
}
\examples{
Normal.example <- function(mean=0,sd=1,n=10){
  x <- rnorm(n=n,mean=mean,sd=sd)
  c(
    Mean=mean(x),
    Median=median(x),
    Var=var(x)
  )
}

Sim_default_bucket <- Simulate(
    Normal.example(mean,sd,n),
    expand.grid(
          mean=0,
          sd=c(1,10),
          n=c(10,100)
          ),
    nsim=200)



tempfile_bucket <- function(n)textfile_bucket(n,name=tempfile())

Sim_textfile_bucket <- Simulate(
    Normal.example(mean,sd,n),
    expand.grid(
          mean=0,
          sd=c(1,10),
          n=c(10,100)
          ),
    nsim=200,
    bucket=tempfile_bucket
    )


Sim_default_bucket
Sim_default_bucket[1:10]

Sim_textfile_bucket
Sim_textfile_bucket[1:10]

# Access of the textfile generated by 'textfile_bucket':
Sim_textfile_bucket$name
read.table(Sim_textfile_bucket$name,header=TRUE,nrow=10)

}