% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_lm.R
\name{el_lm}
\alias{el_lm}
\title{Fits a linear model with empirical likelihood}
\usage{
el_lm(formula, data, weights, na.action, control = list(), model = TRUE)
}
\arguments{
\item{formula}{A formula object.}

\item{data}{A data frame containing the variables in the formula.}

\item{weights}{An optional numeric vector of weights to be used in the
fitting process. If not provided, identical weights are applied. Otherwise,
weighted empirical likelihood is computed.}

\item{na.action}{A function which indicates what should happen when the data
contain \code{NA}s.}

\item{control}{A list of control parameters. See ‘Details’ in
\code{\link{el_eval}}.}

\item{model}{A logical. If \code{TRUE} the model matrix used for fitting is
returned.}
}
\value{
A list with class \code{c("el_lm", "el_test")}.
}
\description{
Fits a linear model with empirical likelihood.
}
\examples{
fit <- el_lm(mpg ~ wt, mtcars)
summary(fit)
}
\references{
Owen, Art. 1991. “Empirical Likelihood for Linear Models.”
  The Annals of Statistics 19 (4).
  \doi{10.1214/aos/1176348368}.
}
\seealso{
\link{el_eval}, \link{lht}
}
