% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/med.h.R
\name{med}
\alias{med}
\title{Mediation}
\usage{
med(data, dep, med, pred, estMethod = "standard", bootstrap = 1000,
  test = TRUE, ci = FALSE, ciWidth = 95, pm = FALSE, paths = FALSE,
  label = FALSE, estPlot = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{dep}{a string naming the dependent variable}

\item{med}{a string naming the mediator variable}

\item{pred}{a string naming the predictor variable}

\item{estMethod}{\code{'standard'} (default), or \code{'bootstrap'}, the 
estimation method to use}

\item{bootstrap}{a number between 1 and 100000 (default: 1000) specifying 
the number of  samples that need to been drawn in the bootstrap method}

\item{test}{\code{TRUE} (default) or \code{FALSE}, provide 'Z' and 'p' 
values for the mediation estimates}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide a confidence 
interval for the mediation estimates}

\item{ciWidth}{a number between 50 and 99.9 (default: 95) specifying the 
confidence interval width that is used as \code{'ci'}}

\item{pm}{\code{TRUE} or \code{FALSE} (default), provide the percent 
mediation  effect size for the mediation estimates}

\item{paths}{\code{TRUE} or \code{FALSE} (default), provide the individual 
estimates of the  paths in the mediation model}

\item{label}{\code{TRUE} (default) or \code{FALSE}, provide insightful 
labels for all estimates}

\item{estPlot}{\code{TRUE} or \code{FALSE} (default), provide an estimate 
plot where for each estimator the estimated coefficient and confidence 
intervals are plotted.}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$med} \tab \tab \tab \tab \tab a table containing mediation estimates \cr
  \code{results$paths} \tab \tab \tab \tab \tab a table containing the individual path estimates \cr
  \code{results$estPlot} \tab \tab \tab \tab \tab an image \cr
  \code{results$modelSyntax} \tab \tab \tab \tab \tab the lavaan syntax used to fit the mediation model \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$med$asDF}

\code{as.data.frame(results$med)}
}
\description{
Simple mediation analysis
}
\examples{
set.seed(1234)
X <- rnorm(10)
M <- 0.5*X + rnorm(10)
Y <- 0.7*M + rnorm(10)
dat <- data.frame(X=X, M=M, Y=Y)

med(dat, dep = "Y", pred = "X", med = "M")

#
#  Mediation Estimates                                   
#  ----------------------------------------------------- 
#    Effect      Estimate    SE        Z        p        
#  ----------------------------------------------------- 
#    Indirect      0.3736    0.0920    4.059    < .001   
#    Direct        0.0364    0.1044    0.348     0.728   
#    Total         0.4100    0.1247    3.287     0.001   
#  ----------------------------------------------------- 
# 
#

}
