% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neModel.R
\name{plot.neModel}
\alias{plot.neModel}
\alias{plot.neModelBoot}
\title{Confidence interval plots for natural effect components}
\usage{
\method{plot}{neModel}(x, xRef, covLev, level = 0.95,
  transf = identity, ylabels, yticks.at, ...)

\method{plot}{neModelBoot}(x, xRef, covLev, level = 0.95,
  ci.type = "norm", transf = identity, ylabels, yticks.at, ...)
}
\arguments{
\item{x}{a fitted natural effect model object.}

\item{xRef}{a vector including reference levels for the exposure, \emph{x*} and \emph{x}, at which natural effect components need to be evaluated (see details).}

\item{covLev}{a vector including covariate levels at which natural effect components need to be evaluated (see details).}

\item{level}{the confidence level required.}

\item{transf}{transformation function to be applied internally on the (linear hypothesis) estimates and their confidence intervals (e.g. \code{exp} for logit or Poisson regression). The default is \code{identity} (i.e. no transformation).}

\item{ylabels}{character vector containing the labels for the (linear hypothesis) estimates to be plotted on the y-axis.}

\item{yticks.at}{numeric vector containing the y-coordinates (from 0 to 1) to draw the tick marks for the different estimates and their corresponding confidence intervals.}

\item{...}{additional arguments.}

\item{ci.type}{the type of bootstrap intervals required (see \code{type} argument in \code{\link[medflex]{neModel-methods}}).}
}
\description{
Obtain effect decomposition confidence interval plots for natural effect models.
}
\details{
This function yields confidence interval plots for the natural effect components.
These causal parameter estimates are first internally extracted from the \code{neModel} object by applying the effect decomposition function \code{\link{neEffdecomp}(x, xRef, covLev)}.
}
\examples{
data(UPBdata)

impData <- neImpute(UPB ~ att * negaff + educ + gender + age, 
                    family = binomial, data = UPBdata)
neMod <- neModel(UPB ~ att0 * att1 + educ + gender + age, 
                 family = binomial, expData = impData, se = "robust")

plot(neMod)
plot(neMod, transf = exp, 
     ylabels = c("PDE", "TDE", "PIE", "TIE", "TE"))
plot(neMod, level = 0.9, xRef = c(-1, 0))
}
