% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.neModel}
\alias{plot.neModel}
\title{Confidence interval plots for natural effect estimates}
\usage{
\method{plot}{neModel}(x, level = 0.95, ci.type = "norm",
  transf = identity, ylabels, yticks.at, ...)
}
\arguments{
\item{x}{a fitted natural effect model object.}

\item{level}{the confidence level required.}

\item{ci.type}{the type of bootstrap intervals required. The default \code{"norm"} returns normal approximation bootstrap confidence intervals. Currently, only \code{"norm"}, \code{"basic"} and \code{"perc"} are supported (see \code{\link[boot]{boot.ci}}).}

\item{transf}{transformation function to be applied internally on the (linear hypothesis) estimates and their confidence intervals (e.g. \code{exp} for logit or Poisson regression). The default is \code{identity} (i.e. no transformation).}

\item{ylabels}{character vector containing the labels for the (linear hypothesis) estimates to be plotted on the y-axis.}

\item{yticks.at}{numeric vector containing the y-coordinates (from 0 to 1) to draw the tick marks for the different estimates and their corresponding confidence intervals.}

\item{...}{additional arguments.}
}
\description{
Obtain effect decomposition confidence interval plots for natural effect models.
}
\details{
This function yields confidence interval plots for the natural effect parameters of interest.
These causal parameter estimates are first internally extracted from the \code{neModel} object by applying\cr\code{\link{neEffdecomp}}.
}
\examples{
data(UPBdata)

impData <- neImpute(UPB ~ att * negaffect + educ + gender + age,
                    family = binomial, data = UPBdata)
\donttest{neMod <- neModel(UPB ~ att0 * att1 + educ + gender + age,
                 family = binomial, expData = impData)}\dontshow{neMod <- neModel(UPB ~ att0 * att1 + educ + gender + age, family = binomial, expData = impData, nBoot = 2)}

plot(neMod)
plot(neMod, transf = exp,
     ylabels = c("PDE", "TDE", "PIE", "TIE", "TE"))
}

