library(medfate)

data(examplemeteo)
data(exampleforestMED)
data(SpParamsMED)
d = 100:105
examplesoil = soil(defaultSoilParams(4))


test_that("Can produce all basic spwb plots and summaries",{
  control = defaultControl("Granier")
  control$verbose = FALSE
  x1 = forest2spwbInput(exampleforestMED,examplesoil, SpParamsMED, control)
  expect_s3_class(x1, "spwbInput")
  S1<-spwb(x1, examplemeteo[d,], latitude = 41.82592, elevation = 100)
  expect_s3_class(S1, "spwb")
  expect_type(fireHazard(S1, SpParamsMED, exampleforestMED), "double")
  expect_s3_class(plot(S1, "PET_Precipitation"), "ggplot")
  expect_s3_class(plot(S1, "PET_NetRain"), "ggplot")
  expect_s3_class(plot(S1, "Snow"), "ggplot")
  expect_s3_class(plot(S1, "Export"), "ggplot")
  expect_s3_class(plot(S1, "WTD"), "ggplot")
  expect_s3_class(plot(S1, "Evapotranspiration"), "ggplot")
  expect_s3_class(plot(S1, "SoilPsi"), "ggplot")
  expect_s3_class(plot(S1, "SoilRWC"), "ggplot")
  expect_s3_class(plot(S1, "SoilTheta"), "ggplot")
  expect_s3_class(plot(S1, "SoilVol"), "ggplot")
  expect_s3_class(plot(S1, "PlantExtraction"), "ggplot")
  expect_s3_class(plot(S1, "HydraulicRedistribution"), "ggplot")
  expect_s3_class(plot(S1, "LAI"), "ggplot")
  expect_s3_class(plot(S1, "PlantLAI"), "ggplot")
  expect_s3_class(plot(S1, "PlantLAIlive"), "ggplot")
  expect_s3_class(plot(S1, "PlantStress"), "ggplot")
  expect_s3_class(plot(S1, "StemPLC"), "ggplot")
  expect_s3_class(plot(S1, "PlantPsi"), "ggplot")
  expect_s3_class(plot(S1, "PlantTranspiration"), "ggplot")
  expect_s3_class(plot(S1, "TranspirationPerLeaf"), "ggplot")
  expect_s3_class(plot(S1, "PlantGrossPhotosynthesis"), "ggplot")
  expect_s3_class(plot(S1, "GrossPhotosynthesisPerLeaf"), "ggplot")
  expect_type(summary(S1, output = "WaterBalance"), "double")
  expect_type(summary(S1, output = "Soil"), "double")
  expect_type(summary(S1, output = "Stand"), "double")
  expect_type(summary(S1, output = "Plants$LAI"), "double")
  expect_type(summary(S1, output = "AbsorbedSWRFraction"), "double")
  expect_type(summary(S1, output = "Transpiration"), "double")
  expect_type(summary(S1, output = "GrossPhotosynthesis"), "double")
  expect_type(summary(S1, output = "PlantPsi"), "double")
  expect_type(summary(S1, output = "StemPLC"), "double")
  expect_type(summary(S1, output = "PlantStress"), "double")
  expect_type(droughtStress(S1, index = "ADS", draw=FALSE), "double")
  expect_type(waterUseEfficiency(S1, type = "Plant Ag/E", draw=FALSE), "double")
  expect_type(waterUseEfficiency(S1, type = "Stand Ag/E", draw=FALSE), "double")
})

test_that("Can produce all advanced spwb plots and summaries",{
  for(transpirationMode in c("Sperry", "Cochard")) {
    control = defaultControl(transpirationMode)
    control$verbose = FALSE
    x2 = forest2spwbInput(exampleforestMED,examplesoil, SpParamsMED, control)
    coh_1 = row.names(x2$cohorts)[1]
    expect_s3_class(x2, "spwbInput")
    S2<-spwb(x2, examplemeteo[d,], latitude = 41.82592, elevation = 100)
    expect_s3_class(S2, "spwb")
    expect_type(fireHazard(S2, SpParamsMED, exampleforestMED), "double")
    expect_s3_class(plot(S2, "SoilPlantConductance"), "ggplot")
    expect_s3_class(plot(S2, "LeafPsiMin"), "ggplot")
    expect_s3_class(plot(S2, "LeafPsiMax"), "ggplot")
    expect_s3_class(plot(S2, "LeafPsiRange"), "ggplot")
    expect_s3_class(plot(S2, "StemPsi"), "ggplot")
    expect_s3_class(plot(S2, "RootPsi"), "ggplot")
    expect_s3_class(plot(S2, "TempMin_SL"), "ggplot")
    expect_s3_class(plot(S2, "TempMin_SH"), "ggplot")
    expect_s3_class(plot(S2, "TempMax_SL"), "ggplot")
    expect_s3_class(plot(S2, "TempMax_SH"), "ggplot")
    expect_s3_class(plot(S2, "GSWMin_SL"), "ggplot")
    expect_s3_class(plot(S2, "GSWMin_SH"), "ggplot")
    expect_s3_class(plot(S2, "GSWMax_SL"), "ggplot")
    expect_s3_class(plot(S2, "GSWMax_SH"), "ggplot")
    expect_s3_class(plot(S2, "LeafPsiMin_SL"), "ggplot")
    expect_s3_class(plot(S2, "LeafPsiMin_SH"), "ggplot")
    expect_s3_class(plot(S2, "LeafPsiMax_SL"), "ggplot")
    expect_s3_class(plot(S2, "LeafPsiMax_SH"), "ggplot")
    expect_s3_class(plot(S2, "StemRWC"), "ggplot")
    expect_s3_class(plot(S2, "LeafRWC"), "ggplot")
    expect_s3_class(plot(S2, "LFMC"), "ggplot")
    expect_s3_class(plot(S2, "PlantWaterBalance"), "ggplot")
    expect_s3_class(plot(S2, "PlantNetPhotosynthesis"), "ggplot")
    expect_s3_class(plot(S2, "NetPhotosynthesisPerLeaf"), "ggplot")
    expect_s3_class(plot(S2, "PlantWUE"), "ggplot")
    expect_s3_class(plot(S2, "PlantAbsorbedSWR"), "ggplot")
    expect_s3_class(plot(S2, "AbsorbedSWRPerLeaf"), "ggplot")
    expect_s3_class(plot(S2, "PlantNetLWR"), "ggplot")
    expect_s3_class(plot(S2, "NetLWRPerLeaf"), "ggplot")
    expect_s3_class(plot(S2, "Temperature"), "ggplot")
    expect_s3_class(plot(S2, "AirTemperature"), "ggplot")
    expect_s3_class(plot(S2, "CanopyTemperature"), "ggplot")
    expect_s3_class(plot(S2, "SoilTemperature"), "ggplot")
    expect_s3_class(plot(S2, "CanopyEnergyBalance"), "ggplot")
    expect_s3_class(plot(S2, "SoilEnergyBalance"), "ggplot")
    expect_type(summary(S2, output = "AbsorbedSWR"), "double")
    expect_type(summary(S2, output = "NetLWR"), "double")
    expect_type(summary(S2, output = "NetPhotosynthesis"), "double")
    expect_type(summary(S2, output = "dEdP"), "double")
    expect_type(summary(S2, output = "PlantWaterBalance"), "double")
    expect_type(summary(S2, output = "LeafPsiMin"), "double")
    expect_type(summary(S2, output = "LeafPsiMax"), "double")
    expect_type(summary(S2, output = "LeafRWC"), "double")
    expect_type(summary(S2, output = "StemRWC"), "double")
    expect_type(summary(S2, output = "LFMC"), "double")
    expect_type(summary(S2, output = "StemPsi"), "double")
    expect_type(summary(S2, output = "RootPsi"), "double")
    expect_type(summary(S2, output = "SunlitLeaves$LeafPsiMin"), "double")
    expect_type(summary(S2, output = "ShadeLeaves$LeafPsiMin"), "double")
    expect_type(summary(S2, output = "SunlitLeaves$LeafPsiMax"), "double")
    expect_type(summary(S2, output = "ShadeLeaves$LeafPsiMax"), "double")
    expect_type(summary(S2, output = "SunlitLeaves$TempMin"), "double")
    expect_type(summary(S2, output = "ShadeLeaves$TempMin"), "double")
    expect_type(summary(S2, output = "SunlitLeaves$TempMax"), "double")
    expect_type(summary(S2, output = "ShadeLeaves$TempMax"), "double")
    expect_type(summary(S2, output = "SunlitLeaves$GSWMin"), "double")
    expect_type(summary(S2, output = "ShadeLeaves$GSWMin"), "double")
    expect_type(summary(S2, output = "SunlitLeaves$GSWMax"), "double")
    expect_type(summary(S2, output = "ShadeLeaves$GSWMax"), "double")
    expect_type(droughtStress(S2, index = "ADS", draw=FALSE), "double")
    expect_type(waterUseEfficiency(S2, "Plant An/E", draw=FALSE), "double")
    expect_type(waterUseEfficiency(S2, "Stand An/E", draw=FALSE), "double")
    expect_type(resistances(S2, cohort = coh_1, draw=FALSE), "double")
  }
})

test_that("Can produce all advanced subdaily spwb plots",{
  for(transpirationMode in c("Sperry", "Cochard")) {
    control = defaultControl(transpirationMode)
    control$verbose = FALSE
    control$subdailyResults = TRUE
    x2 = forest2spwbInput(exampleforestMED,examplesoil, SpParamsMED, control)
    expect_s3_class(x2, "spwbInput")
    S2<-spwb(x2, examplemeteo[d,], latitude = 41.82592, elevation = 100)
    expect_s3_class(S2, "spwb")
    
    expect_s3_class(plot(S2, "LeafPsi", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafPsiAverage", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "RootPsi", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "StemPsi", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "StemRWC", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafRWC", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "StemPLC", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "StemSympRWC", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafSympRWC", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "StemSympPsi", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafSympPsi", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "PlantExtraction", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "PlantTranspiration", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafTranspiration", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "TranspirationPerLeaf", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "PlantGrossPhotosynthesis", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafGrossPhotosynthesis", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "PlantNetPhotosynthesis", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafNetPhotosynthesis", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafAbsorbedPAR", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafAbsorbedSWR", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafNetLWR", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafCi", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafIntrinsicWUE", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafVPD", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafStomatalConductance", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "LeafTemperature", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "Temperature", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(S2, "PlantWaterBalance", subdaily = TRUE), "ggplot")
    expect_type(waterUseEfficiency(S2, type = "Leaf Ci", draw=FALSE), "double")
    expect_type(waterUseEfficiency(S2, type = "Leaf iWUE", draw=FALSE), "double")
    expect_s3_class(extractSubdaily(S2, output="E"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="Ag"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="An"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="dEdP"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="RootPsi"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="StemPsi"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="StemPLC"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="StemRWC"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="LeafRWC"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="StemSympRWC"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="LeafSympRWC"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="PWB"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="Temperature"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="ExtractionInst"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$Abs_PAR"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$Abs_SWR"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$Net_LWR"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$E"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$Ag"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$An"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$Ci"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$Gsw"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$VPD"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$Temp"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$Psi"), "data.frame")
    expect_s3_class(extractSubdaily(S2, output="SunlitLeaves$iWUE"), "data.frame")    
  }    
})

test_that("Can produce all advanced spwb_day plots",{
  for(transpirationMode in c("Sperry", "Cochard")) {
    control = defaultControl(transpirationMode)
    control$verbose = FALSE
    x2 = forest2spwbInput(exampleforestMED,examplesoil, SpParamsMED, control)
    expect_s3_class(x2, "spwbInput")
    d1 = d[1]
    sd2<-spwb_day(x2, rownames(examplemeteo)[d1],
                  unlist(examplemeteo[d1,]), 
                  latitude = 41.82592, elevation = 100, slope=0, aspect=0)
    expect_s3_class(sd2, "spwb_day")
    expect_type(fireHazard(sd2, SpParamsMED, exampleforestMED), "double")
    expect_s3_class(plot(sd2, "LeafPsi"), "ggplot")
    expect_s3_class(plot(sd2, "LeafPsiAverage"), "ggplot")
    expect_s3_class(plot(sd2, "RootPsi"), "ggplot")
    expect_s3_class(plot(sd2, "StemPsi"), "ggplot")
    expect_s3_class(plot(sd2, "StemPLC"), "ggplot")
    expect_s3_class(plot(sd2, "StemRWC"), "ggplot")
    expect_s3_class(plot(sd2, "LeafRWC"), "ggplot")
    expect_s3_class(plot(sd2, "StemSympRWC"), "ggplot")
    expect_s3_class(plot(sd2, "LeafSympRWC"), "ggplot")
    expect_s3_class(plot(sd2, "SoilPlantConductance"), "ggplot")
    expect_s3_class(plot(sd2, "PlantExtraction"), "ggplot")
    expect_s3_class(plot(sd2, "PlantTranspiration"), "ggplot")
    expect_s3_class(plot(sd2, "TranspirationPerLeaf"), "ggplot")
    expect_s3_class(plot(sd2, "PlantGrossPhotosynthesis"), "ggplot")
    expect_s3_class(plot(sd2, "GrossPhotosynthesisPerLeaf"), "ggplot")
    expect_s3_class(plot(sd2, "PlantNetPhotosynthesis"), "ggplot")
    expect_s3_class(plot(sd2, "NetPhotosynthesisPerLeaf"), "ggplot")
    expect_s3_class(plot(sd2, "LeafTranspiration"), "ggplot")
    expect_s3_class(plot(sd2, "LeafGrossPhotosynthesis"), "ggplot")
    expect_s3_class(plot(sd2, "LeafNetPhotosynthesis"), "ggplot")
    expect_s3_class(plot(sd2, "LeafAbsorbedSWR"), "ggplot")
    expect_s3_class(plot(sd2, "LeafAbsorbedPAR"), "ggplot")
    expect_s3_class(plot(sd2, "LeafNetLWR"), "ggplot")
    expect_s3_class(plot(sd2, "LeafCi"), "ggplot")
    expect_s3_class(plot(sd2, "LeafIntrinsicWUE"), "ggplot")
    expect_s3_class(plot(sd2, "LeafStomatalConductance"), "ggplot")
    expect_s3_class(plot(sd2, "LeafTemperature"), "ggplot")
    expect_s3_class(plot(sd2, "Temperature"), "ggplot")
    expect_s3_class(plot(sd2, "CanopyEnergyBalance"), "ggplot")
    expect_s3_class(plot(sd2, "SoilEnergyBalance"), "ggplot")
    expect_s3_class(plot(sd2, "PlantWaterBalance"), "ggplot")
    expect_s3_class(plot(sd2, "WaterBalancePerLeaf"), "ggplot")    
  }
})

test_that("Can produce all basic growth plots and summaries",{
  examplesoil = soil(defaultSoilParams(2))
  control = defaultControl("Granier")
  control$verbose = FALSE
  x1 = forest2growthInput(exampleforestMED,examplesoil, SpParamsMED, control)
  expect_s3_class(x1, "growthInput")
  G1<-growth(x1, examplemeteo[d,], latitude = 41.82592, elevation = 100)
  expect_s3_class(G1, "growth")
  
  expect_type(fireHazard(G1, SpParamsMED, exampleforestMED), "double")
  expect_s3_class(plot(G1, "CarbonBalance"), "ggplot")
  expect_s3_class(plot(G1, "BiomassBalance"), "ggplot")
  expect_s3_class(plot(G1, "GrossPhotosynthesis"), "ggplot")
  expect_s3_class(plot(G1, "MaintenanceRespiration"), "ggplot")
  expect_s3_class(plot(G1, "LabileCarbonBalance"), "ggplot")
  expect_s3_class(plot(G1, "SugarLeaf"), "ggplot")
  expect_s3_class(plot(G1, "StarchLeaf"), "ggplot")
  expect_s3_class(plot(G1, "SugarSapwood"), "ggplot")
  expect_s3_class(plot(G1, "StarchSapwood"), "ggplot")
  expect_s3_class(plot(G1, "SugarTransport"), "ggplot")
  expect_s3_class(plot(G1, "RootExudation"), "ggplot")
  expect_s3_class(plot(G1, "StructuralBiomassBalance"), "ggplot")
  expect_s3_class(plot(G1, "LabileBiomassBalance"), "ggplot")
  expect_s3_class(plot(G1, "PlantBiomassBalance"), "ggplot")
  expect_s3_class(plot(G1, "MortalityBiomassLoss"), "ggplot")
  expect_s3_class(plot(G1, "CohortBiomassBalance"), "ggplot")
  expect_s3_class(plot(G1, "SapwoodArea"), "ggplot")
  expect_s3_class(plot(G1, "LeafArea"), "ggplot")
  expect_s3_class(plot(G1, "FineRootBiomass"), "ggplot")
  expect_s3_class(plot(G1, "DBH"), "ggplot")
  expect_s3_class(plot(G1, "Height"), "ggplot")
  expect_s3_class(plot(G1, "SAgrowth"), "ggplot")
  expect_s3_class(plot(G1, "LAgrowth"), "ggplot")
  expect_s3_class(plot(G1, "HuberValue"), "ggplot")
  expect_type(summary(G1, output = "CarbonBalance"), "double")
  expect_type(summary(G1, output = "LabileCarbonBalance$GrossPhotosynthesis"), "double")
  expect_type(summary(G1, output = "MaintenanceRespiration"), "double")
  expect_type(summary(G1, output = "GrowthCosts"), "double")
  expect_type(summary(G1, output = "RootExudation"), "double")
  expect_type(summary(G1, output = "LabileCarbonBalance"), "double")
  expect_type(summary(G1, output = "SugarLeaf"), "double")
  expect_type(summary(G1, output = "StarchLeaf"), "double")
  expect_type(summary(G1, output = "SugarSapwood"), "double")
  expect_type(summary(G1, output = "StarchSapwood"), "double")
  expect_type(summary(G1, output = "SugarTransport"), "double")
  expect_type(summary(G1, output = "LeafArea"), "double")
  expect_type(summary(G1, output = "SapwoodArea"), "double")
  expect_type(summary(G1, output = "FineRootBiomass"), "double")
  expect_type(summary(G1, output = "LAgrowth"), "double")
  expect_type(summary(G1, output = "SAgrowth"), "double")
  expect_type(droughtStress(G1, index = "ADS", draw=FALSE), "double")
  expect_type(waterUseEfficiency(G1, type = "Plant Ag/E", draw=FALSE), "double")
  expect_type(waterUseEfficiency(G1, type = "Stand Ag/E", draw=FALSE), "double")
  
})

test_that("Can produce all advanced growth plots and summaries",{
  for(transpirationMode in c("Sperry", "Cochard")) {
    control = defaultControl(transpirationMode)
    control$verbose = FALSE
    x2 = forest2growthInput(exampleforestMED,examplesoil, SpParamsMED, control)
    coh_1 = row.names(x2$cohorts)[1]
    expect_s3_class(x2, "growthInput")
    G2<-growth(x2, examplemeteo[d,], latitude = 41.82592, elevation = 100)
    expect_s3_class(G2, "growth")
    expect_type(fireHazard(G2, SpParamsMED, exampleforestMED), "double")
    expect_s3_class(plot(G2, "FineRootArea"), "ggplot")
    expect_s3_class(plot(G2, "FRAgrowth"), "ggplot")
    expect_s3_class(plot(G2, "RootAreaLeafArea"), "ggplot")
    expect_type(summary(G2, output = "FineRootArea"), "double")
    expect_type(summary(G2, output = "FRAgrowth"), "double")
    expect_type(droughtStress(G2, index = "ADS", draw=FALSE), "double")
    expect_type(waterUseEfficiency(G2, "Plant An/E", draw=FALSE), "double")
    expect_type(waterUseEfficiency(G2, "Stand An/E", draw=FALSE), "double")  
    expect_type(resistances(G2, cohort = coh_1, draw=FALSE), "double")
  }  
})

test_that("Can produce all advanced subdaily growth plots",{
  for(transpirationMode in c("Sperry", "Cochard")) {
    control = defaultControl(transpirationMode)
    control$verbose = FALSE
    control$subdailyResults = TRUE
    control$subdailyCarbonBalance = TRUE
    x2 = forest2growthInput(exampleforestMED,examplesoil, SpParamsMED, control)
    expect_s3_class(x2, "growthInput")
    G2<-growth(x2, examplemeteo[d,], latitude = 41.82592, elevation = 100)
    expect_s3_class(G2, "growth")
    
    expect_s3_class(plot(G2, "GrossPhotosynthesis", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(G2, "MaintenanceRespiration", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(G2, "GrowthCosts", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(G2, "RootExudation", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(G2, "LabileCarbonBalance", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(G2, "SugarTransport", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(G2, "SugarLeaf", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(G2, "SugarSapwood", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(G2, "StarchLeaf", subdaily = TRUE), "ggplot")
    expect_s3_class(plot(G2, "StarchSapwood", subdaily = TRUE), "ggplot")
    expect_type(waterUseEfficiency(G2, type = "Leaf Ci", draw=FALSE), "double")
    expect_type(waterUseEfficiency(G2, type = "Leaf iWUE", draw=FALSE), "double")
    expect_s3_class(extractSubdaily(G2, output="GrossPhotosynthesis"), "data.frame")
    expect_s3_class(extractSubdaily(G2, output="MaintenanceRespiration"), "data.frame")
    expect_s3_class(extractSubdaily(G2, output="GrowthCosts"), "data.frame")
    expect_s3_class(extractSubdaily(G2, output="RootExudation"), "data.frame")
    expect_s3_class(extractSubdaily(G2, output="LabileCarbonBalance"), "data.frame")
    expect_s3_class(extractSubdaily(G2, output="SugarLeaf"), "data.frame")
    expect_s3_class(extractSubdaily(G2, output="SugarSapwood"), "data.frame")
    expect_s3_class(extractSubdaily(G2, output="StarchLeaf"), "data.frame")
    expect_s3_class(extractSubdaily(G2, output="StarchSapwood"), "data.frame")
    expect_s3_class(extractSubdaily(G2, output="SugarTransport"), "data.frame")
  }
})

test_that("Can produce all advanced growth_day plots",{
  for(transpirationMode in c("Sperry", "Cochard")) {
    control = defaultControl(transpirationMode)
    control$verbose <- FALSE
    control$subdailyCarbonBalance <- TRUE
    x2 <- forest2growthInput(exampleforestMED,examplesoil, SpParamsMED, control)
    expect_s3_class(x2, "growthInput")
    d1 <- d[1]
    sd2<-growth_day(x2, rownames(examplemeteo)[d1],
                    unlist(examplemeteo[d1,]), 
                    latitude = 41.82592, elevation = 100, slope=0, aspect=0)
    expect_s3_class(sd2, "growth_day")
    expect_type(fireHazard(sd2, SpParamsMED, exampleforestMED), "double")
    expect_s3_class(plot(sd2, "GrossPhotosynthesis"), "ggplot")
    expect_s3_class(plot(sd2, "MaintenanceRespiration"), "ggplot")
    expect_s3_class(plot(sd2, "RootExudation"), "ggplot")
    expect_s3_class(plot(sd2, "LabileCarbonBalance"), "ggplot")
    expect_s3_class(plot(sd2, "SugarLeaf"), "ggplot")
    expect_s3_class(plot(sd2, "StarchLeaf"), "ggplot")
    expect_s3_class(plot(sd2, "SugarSapwood"), "ggplot")
    expect_s3_class(plot(sd2, "StarchSapwood"), "ggplot")
    expect_s3_class(plot(sd2, "SugarTransport"), "ggplot")
  }  
})

test_that("Can produce all fordyn plots",{
  control <- defaultControl("Granier")
  control$verbose <- FALSE
  fd<-fordyn(exampleforestMED, examplesoil, 
             SpParamsMED, examplemeteo, control,
             latitude = 41.82592, elevation = 100)
  expect_s3_class(plot(fd, "NumTreeSpecies"), "ggplot")
  expect_s3_class(plot(fd, "NumTreeCohorts"), "ggplot")
  expect_s3_class(plot(fd, "NumShrubSpecies"), "ggplot")
  expect_s3_class(plot(fd, "NumShrubCohorts"), "ggplot")
  expect_s3_class(plot(fd, "StandBasalArea"), "ggplot")
  expect_s3_class(plot(fd, "StandDensity"), "ggplot")
  expect_s3_class(plot(fd, "StandShrubCover"), "ggplot")
  expect_s3_class(plot(fd, "SpeciesBasalArea"), "ggplot")
  expect_s3_class(plot(fd, "SpeciesDensity"), "ggplot")
  expect_s3_class(plot(fd, "SpeciesShrubCover"), "ggplot")
  expect_s3_class(plot(fd, "CohortBasalArea"), "ggplot")
  expect_s3_class(plot(fd, "CohortDensity"), "ggplot")
  expect_s3_class(plot(fd, "CohortShrubCover"), "ggplot")
  expect_s3_class(plot(fd, "DominantTreeHeight"), "ggplot")
  expect_s3_class(plot(fd, "DominantTreeDiameter"), "ggplot")
  expect_s3_class(plot(fd, "QuadraticMeanTreeDiameter"), "ggplot")
  expect_s3_class(plot(fd, "HartBeckingIndex"), "ggplot")
})
  