% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{TN}
\alias{TN}
\title{True negatives}
\usage{
TN(truth, response, negative)
}
\arguments{
\item{truth}{vector of true values}

\item{response}{vector of predicted values}

\item{negative}{negative class}
}
\description{
Sum of correctly classified observations in the negative class. Also called correct rejections.
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
negative = 0
TN(truth, response, negative)
}
