% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_multiclass.R
\name{QSR}
\alias{QSR}
\title{Quadratic Scoring Rule}
\usage{
QSR(probabilities, truth)
}
\arguments{
\item{probabilities}{[numeric] vector (or matrix with column names of the classes) of predicted probabilities}

\item{truth}{vector of true values 
n = 20
set.seed(122)
truth = as.factor(sample(c(1,2,3), n, replace = TRUE))
probabilities = matrix(runif(60), 20, 3)
probabilities = probabilities/rowSums(probabilities)
colnames(probabilities) = c(1,2,3)
QSR(probabilities, truth)}
}
\description{
Defined as: 1 - (1/n) sum_i sum_j (y_ij - p_ij)^2, where y_ij = 1 if observation i has class j (else 0), 
and p_ij is the predicted probablity of observation i for class j.
This scoring rule is the same as 1 - multiclass.brier.
See: Bickel, J. E. (2007). Some comparisons among quadratic, spherical, and logarithmic scoring rules. Decision Analysis, 4(2), 49-65.
}
