% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sttc.R
\name{sttcp}
\alias{sttcp}
\title{Compute}
\usage{
sttcp(a, b, dt = 0.05, tau_max = 5, tau_step = 0.1, beg = NULL,
  end = NULL)
}
\arguments{
\item{a}{spike train 1}

\item{b}{spike train 2}

\item{dt}{time window for STTC}

\item{tau_max}{maximum time shift}

\item{tau_step}{step size in tau}

\item{beg}{start of recording. When NULL use the minimum spike time from
the two trains.}

\item{end}{end of recording.  When NULL use the maximum spike time from
the two trains.}
}
\value{
List containing the STTC profile.
}
\description{
Compute STTC profile for a pair of spike trains
}
\details{
We extend the STTC to a profile (or correlogram) by shifting one
spike train by amount tau, where tau varies in [-tau_max, +tau_max]
in steps of tau_step.
}
\examples{
t1 <- -cumsum(log(runif(1000)) / 2)
t2 <- -cumsum(log(runif(1000)) / 2)
corr <- sttcp(t1, t2)
plot(corr, main="cross correlation")
autocorr <- sttcp(t1, t1)
plot(autocorr, main="auto correlation")
}
\author{
Stephen Eglen
}
