% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictFromMultipleChains.R
\name{predictFromMultipleChains}
\alias{predictFromMultipleChains}
\title{Predict from multiple MCMC chains}
\usage{
predictFromMultipleChains(
  mcmc_outputs,
  burn,
  point_estimate_method = "median",
  construct_psm = FALSE,
  chains_already_processed = FALSE
)
}
\arguments{
\item{mcmc_outputs}{Output from ``runMCMCChains``}

\item{burn}{The number of MCMC samples to drop as part of a burn in.}

\item{point_estimate_method}{Summary statistic used to define the point
estimate. Must be ``'mean'`` or ``'median'``. ``'median'`` is the default.}

\item{construct_psm}{Logical indicating if PSMs be constructed in the
unsupervised views. Defaults to FALSE. If TRUE the PSM is constructed and
this is used to infer the point estimate rather than the sampled partitions.}

\item{chains_already_processed}{Logical indicating if the the chains have
been processed already.}
}
\value{
A named list of quantities related to prediction/clustering:

 * ``allocation_probability``: List with an $(N x K)$ matrix for each
   semi-supervised view. The point estimate of the allocation probabilities for
   each data point to each class.

 * ``prob``: List with an $N$ vector for each semi-supervised view. The point
   estimate of the probability of being allocated to the class with the
   highest probability.

 * ``pred``: List of $N$ vectorsfor each semi-supervised view. The predicted
   class for each sample.

 * ``allocations``: List of sampled allocations for each view. Columns
   correspond to items being clustered, rows to MCMC samples.
}
\description{
Applies a burn in to and finds a point estimate by combining
multiple chains of ``callMDI``.
}
\examples{
\donttest{
N <- 100
X <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)
Y <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)

truth <- c(rep(1, N / 2), rep(2, N / 2))
data_modelled <- list(X, Y)

V <- length(data_modelled)

# MCMC parameters
R <- 5000
thin <- 50
burn <- 1000

K_max <- 10
K <- rep(K_max, V)
types <- rep("G", V)

n_chains <- 3
mcmc_out <- runMCMCChains(data_modelled, n_chains, R, thin, types, K = K)
predictFromMultipleChains(mcmc_out, burn)
}
}
