% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcFusionProbabiliyAllViews.R
\name{calcFusionProbabiliyAllViews}
\alias{calcFusionProbabiliyAllViews}
\title{Calculate fusion probability all views}
\usage{
calcFusionProbabiliyAllViews(mcmc, processed = FALSE)
}
\arguments{
\item{mcmc}{Output from ``runMCMCChain``}

\item{processed}{Has the chain been processed already (defaults to FALSE).}
}
\value{
A list of vector of probabilities for each item fusing across each 
pair of views.
}
\description{
The mean of the number of MCMC samples for which each item has 
the same label in each pair of views.
}
\examples{

N <- 100
X <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)
Y <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)
data_modelled <- list(X, Y)

truth <- c(rep(1, N / 2), rep(2, N / 2))

V <- length(data_modelled)

# This R is much too low for real applications
R <- 100
thin <- 5
burn <- 10

K_max <- 10
K <- rep(K_max, V) 
types <- rep("G", V)

mcmc_out <- callMDI(data_modelled, R, thin, types, K = K)
calcFusionProbabiliyAllViews(mcmc_out)

}
