/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram.figures;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import multidendrograms.definitions.Coordinates;
import multidendrograms.dendrogram.Scaling;
import multidendrograms.dendrogram.eps.EpsUtils;
import multidendrograms.dendrogram.figures.Figure;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.PlotType;

public class Node
extends Figure {
    private double radius;
    private String name;
    private Scaling scalingDendro;

    public Node(double d, double d2, double d3, String string) {
        super(d, d2);
        this.radius = d3;
        this.name = string;
    }

    public double getRadius() {
        return this.radius;
    }

    public String getName() {
        return this.name;
    }

    public void setScalingDendrogram(Scaling scaling) {
        this.scalingDendro = scaling;
    }

    @Override
    public void draw(PlotType plotType, Graphics2D graphics2D) {
        double d = this.getPosReal().getX();
        double d2 = this.getPosReal().getY();
        Coordinates<Double> coordinates = new Coordinates<Double>(d, d2);
        DendrogramOrientation dendrogramOrientation = this.getDendrogramOrientation();
        Coordinates<Double> coordinates2 = this.scalingDendro.transform(coordinates, dendrogramOrientation);
        double d3 = coordinates2.getX();
        double d4 = coordinates2.getY();
        Scaling scaling = this.getScaling();
        double d5 = scaling.scaleX(this.radius);
        double d6 = scaling.scaleY(this.radius);
        double d7 = Math.min(d5, d6);
        if (plotType.equals((Object)PlotType.PANEL)) {
            graphics2D.fill(new Ellipse2D.Double(d3 -= d7 / 2.0, d4 -= d7 / 2.0, d7, d7));
        } else if (plotType.equals((Object)PlotType.EPS)) {
            EpsUtils.writeLine(EpsUtils.fCircle((float)((double)EpsUtils.xmin + d3), (float)((double)EpsUtils.ymax + d4), (float)d7));
        }
    }
}

