/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram.eps;

import java.util.LinkedList;
import multidendrograms.definitions.Config;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.dendrogram.Clipping;
import multidendrograms.dendrogram.Scaling;
import multidendrograms.dendrogram.figures.Axis;
import multidendrograms.dendrogram.figures.AxisLabel;
import multidendrograms.dendrogram.figures.Band;
import multidendrograms.dendrogram.figures.Line;
import multidendrograms.dendrogram.figures.Node;
import multidendrograms.dendrogram.figures.NodeLabel;
import multidendrograms.forms.XYBox;
import multidendrograms.forms.children.DendrogramPanel;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.PlotType;

public class EpsPlot {
    private Config cfg = null;
    private LinkedList<Node> nodesList;
    private LinkedList<Line> linesList;
    private LinkedList<Band> bandsList;
    private DendrogramPanel dendroPanel;
    private final int xMax;
    private final int yMax;

    public EpsPlot(DendrogramPanel dendrogramPanel, Config config, int n, int n2) {
        this.dendroPanel = dendrogramPanel;
        this.nodesList = dendrogramPanel.getNodesList();
        this.linesList = dendrogramPanel.getLinesList();
        this.bandsList = dendrogramPanel.getBandsList();
        this.xMax = n;
        this.yMax = n2;
        this.setConfig(config);
    }

    public void setConfig(Config config) {
        this.cfg = config;
    }

    public DendrogramPanel getDendrogramPanel() {
        return this.dendroPanel;
    }

    public void setDendrogramPanel(DendrogramPanel dendrogramPanel) {
        this.dendroPanel = dendrogramPanel;
    }

    public void drawDendro() {
        double d = (double)this.xMax - 72.0;
        double d2 = (double)this.yMax - 72.0;
        XYBox xYBox = new XYBox(this.cfg, d, d2);
        Scaling scaling = xYBox.getScalingDendrogram();
        Scaling scaling2 = xYBox.getScalingBullets();
        Scaling scaling3 = xYBox.getScalingAxis();
        Scaling scaling4 = xYBox.getScalingAxisLabels();
        DendrogramOrientation dendrogramOrientation = this.cfg.getDendrogramOrientation();
        if (dendrogramOrientation == DendrogramOrientation.NORTH || dendrogramOrientation == DendrogramOrientation.SOUTH) {
            double d3 = scaling2.getHeight() / 2.0;
            scaling2.setHeight(d3);
        } else {
            double d4 = scaling2.getWidth() / 2.0;
            scaling2.setWidth(d4);
        }
        this.drawDendrogram(scaling);
        this.drawBullets(scaling2, scaling);
        this.drawNodesNames(scaling);
        this.drawAxis(scaling3);
        this.drawAxisLabels(scaling4);
    }

    private void drawDendrogram(Scaling scaling) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        Clipping clipping = new Clipping(this.cfg.getProximityType(), this.cfg.getAxisMinValue(), this.cfg.getAxisMaxValue());
        for (Band object : clipping.clipBands(this.bandsList)) {
            Band band = new Band(object.getPosReal().getX(), object.getPosReal().getY(), object.getHeight(), object.getWidth(), object.getColor());
            band.setDendrogramOrientation(this.cfg.getDendrogramOrientation());
            band.setScaling(scaling);
            band.setColor(settingsInfo.getBandColor());
            band.setFilled(true);
            band.draw(PlotType.EPS, null);
        }
        for (Line line : clipping.clipLines(this.linesList)) {
            Line line2 = new Line(line.getPosReal().getX(), line.getPosReal().getY(), line.getLength(), line.getColor());
            line2.setDendrogramOrientation(this.cfg.getDendrogramOrientation());
            line2.setScaling(scaling);
            line2.draw(PlotType.EPS, null);
        }
        for (Band band : clipping.clipBands(this.bandsList)) {
            Band band2 = new Band(band.getPosReal().getX(), band.getPosReal().getY(), band.getHeight(), band.getWidth(), band.getColor());
            band2.setDendrogramOrientation(this.cfg.getDendrogramOrientation());
            band2.setScaling(scaling);
            band2.setColor(settingsInfo.getBandColor());
            band2.setFilled(false);
            band2.draw(PlotType.EPS, null);
        }
    }

    private void drawBullets(Scaling scaling, Scaling scaling2) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        if (settingsInfo.getNodeRadius() > 0) {
            for (Node node : this.nodesList) {
                Node node2 = new Node(node.getPosReal().getX(), node.getPosReal().getY(), node.getRadius(), node.getName());
                node2.setDendrogramOrientation(this.cfg.getDendrogramOrientation());
                node2.setScaling(scaling);
                node2.setScalingDendrogram(scaling2);
                node2.draw(PlotType.EPS, null);
            }
        }
    }

    private void drawNodesNames(Scaling scaling) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        if (settingsInfo.isNodeNameVisible()) {
            NodeLabel nodeLabel = new NodeLabel(this.nodesList, settingsInfo, scaling);
            nodeLabel.draw(PlotType.EPS, null);
        }
    }

    private void drawAxis(Scaling scaling) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        if (settingsInfo.isAxisVisible() && this.cfg.getAxisTicks() > 0) {
            Axis axis = new Axis(settingsInfo, scaling);
            axis.draw(PlotType.EPS, null);
        }
    }

    private void drawAxisLabels(Scaling scaling) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        if (settingsInfo.isAxisLabelVisible() && this.cfg.getAxisTicks() > 0) {
            AxisLabel axisLabel = new AxisLabel(settingsInfo, scaling);
            axisLabel.draw(PlotType.EPS, null);
        }
    }
}

