/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.definitions.SymmetricMatrix;

public class DendrogramMeasures {
    public static final String TREE_BALANCE_LABEL = "Normalized Tree Balance";
    public static final String COPHENETIC_CORRELATION_LABEL = "Cophenetic Correlation Coefficient";
    public static final String SQUARED_ERROR_LABEL = "Normalized Mean Squared Error";
    public static final String ABSOLUTE_ERROR_LABEL = "Normalized Mean Absolute Error";
    public static final String SPACE_DISTORTION_LABEL = "Space Distortion";
    public static final String DEGREE_CONNECTIVITY_LABEL = "Degree of Connectivity";
    private String treeBalance;
    private String copheneticCorrelation;
    private String squaredError;
    private String absoluteError;
    private String spaceDistortion;
    private String degreeConnectivity;

    public DendrogramMeasures(SymmetricMatrix symmetricMatrix, Dendrogram dendrogram, SymmetricMatrix symmetricMatrix2) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(6);
        numberFormat.setMaximumFractionDigits(6);
        numberFormat.setGroupingUsed(false);
        this.treeBalance = numberFormat.format(dendrogram.normalizedTreeBalance());
        double d = this.copheneticCorrelationCoefficient(symmetricMatrix, symmetricMatrix2);
        this.copheneticCorrelation = Double.isNaN(d) ? "NaN" : numberFormat.format(d);
        this.squaredError = numberFormat.format(this.normalizedMeanError(2.0, symmetricMatrix, symmetricMatrix2));
        this.absoluteError = numberFormat.format(this.normalizedMeanError(1.0, symmetricMatrix, symmetricMatrix2));
        this.spaceDistortion = numberFormat.format(this.spaceDistortion(symmetricMatrix, symmetricMatrix2));
        this.degreeConnectivity = numberFormat.format(this.degreeOfConnectivity(symmetricMatrix, dendrogram.isDistanceBased, symmetricMatrix2));
    }

    public String getTreeBalance() {
        return this.treeBalance;
    }

    public String getCopheneticCorrelation() {
        return this.copheneticCorrelation;
    }

    public String getSquaredError() {
        return this.squaredError;
    }

    public String getAbsoluteError() {
        return this.absoluteError;
    }

    public String getSpaceDistortion() {
        return this.spaceDistortion;
    }

    public String getDegreeOfConnectivity() {
        return this.degreeConnectivity;
    }

    public void save(String string) throws IOException {
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("Normalized Tree Balance            : " + this.treeBalance);
        printWriter.println("Cophenetic Correlation Coefficient : " + this.copheneticCorrelation);
        printWriter.println("Normalized Mean Squared Error      : " + this.squaredError);
        printWriter.println("Normalized Mean Absolute Error     : " + this.absoluteError);
        printWriter.println("Space Distortion                   : " + this.spaceDistortion);
        printWriter.close();
    }

    private double copheneticCorrelationCoefficient(SymmetricMatrix symmetricMatrix, SymmetricMatrix symmetricMatrix2) {
        int n = symmetricMatrix.numberOfRows();
        int n2 = (n - 1) * n / 2;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                d += symmetricMatrix.getElement(i, j);
                d2 += symmetricMatrix2.getElement(i, j);
            }
        }
        d /= (double)n2;
        d2 /= (double)n2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d6 = symmetricMatrix.getElement(i, j);
                double d7 = symmetricMatrix2.getElement(i, j);
                d3 += (d6 - d) * (d7 - d2);
                d4 += (d6 - d) * (d6 - d);
                d5 += (d7 - d2) * (d7 - d2);
            }
        }
        d3 /= (double)n2;
        d4 = Math.sqrt(d4 / (double)n2);
        d5 = Math.sqrt(d5 / (double)n2);
        if (d4 == 0.0 || d5 == 0.0) {
            return Double.NaN;
        }
        return d3 / (d4 * d5);
    }

    private double normalizedMeanError(double d, SymmetricMatrix symmetricMatrix, SymmetricMatrix symmetricMatrix2) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < symmetricMatrix.numberOfRows() - 1; ++i) {
            for (int j = i + 1; j < symmetricMatrix.numberOfRows(); ++j) {
                double d4 = symmetricMatrix.getElement(i, j);
                double d5 = symmetricMatrix2.getElement(i, j);
                d2 += Math.pow(Math.abs(d4 - d5), d);
                d3 += Math.pow(Math.abs(d4), d);
            }
        }
        return d2 / d3;
    }

    private double spaceDistortion(SymmetricMatrix symmetricMatrix, SymmetricMatrix symmetricMatrix2) {
        return (symmetricMatrix2.maximumValue() - symmetricMatrix2.minimumValue()) / (symmetricMatrix.maximumValue() - symmetricMatrix.minimumValue());
    }

    private double degreeOfConnectivity(SymmetricMatrix symmetricMatrix, boolean bl, SymmetricMatrix symmetricMatrix2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < symmetricMatrix.numberOfRows(); ++i) {
            for (int j = i + 1; j < symmetricMatrix.numberOfRows(); ++j) {
                ++n;
                double d = symmetricMatrix.getElement(i, j);
                double d2 = symmetricMatrix2.getElement(i, j);
                if (!(bl && d <= d2) && (bl || !(d >= d2))) continue;
                ++n2;
            }
        }
        return (double)n2 / (double)n;
    }
}

