/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.core.clusterings;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.definitions.SymmetricMatrix;
import multidendrograms.core.utils.MathUtils;

public abstract class HierarchicalClustering {
    protected boolean isDistanceBased;
    private int precision;
    private int nextClusterId = 1;
    private Dendrogram[] roots;
    protected HashMap<Integer, Integer> rootsToIndexes;
    private SymmetricMatrix rootsMatrix;
    private static final int NULL_GROUP = 0;

    public HierarchicalClustering(SymmetricMatrix symmetricMatrix, String[] stringArray, boolean bl, int n) {
        this.isDistanceBased = bl;
        this.precision = n;
        int n2 = symmetricMatrix.numberOfRows();
        this.roots = new Dendrogram[n2];
        for (int i = 0; i < n2; ++i) {
            Dendrogram dendrogram = new Dendrogram(this.nextClusterId, stringArray[i], bl, n);
            ++this.nextClusterId;
            double d = symmetricMatrix.getElement(i, i);
            if (!Double.isNaN(d)) {
                dendrogram.setRootHeights(d);
                dendrogram.setNodesHeights(d);
            }
            this.roots[i] = dendrogram;
        }
        this.mapRootsToIndexes();
        this.rootsMatrix = symmetricMatrix;
    }

    public void build() {
        while (this.numberOfRoots() > 1) {
            this.iteration();
        }
    }

    public void iteration() {
        int[] nArray = this.groupRoots();
        Dendrogram[] dendrogramArray = this.createNewRoots(nArray);
        this.updateInternalProximities(dendrogramArray);
        this.rootsMatrix = this.newProximityMatrix(nArray, dendrogramArray);
        this.roots = dendrogramArray;
        this.mapRootsToIndexes();
    }

    public int numberOfRoots() {
        return this.roots.length;
    }

    public Dendrogram getRoot() {
        return this.roots[0];
    }

    private int[] groupRoots() {
        int n = this.roots.length;
        int[] nArray = new int[n];
        Arrays.fill(nArray, 0);
        int n2 = 1;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d = this.rootsMatrix.getElement(i, j);
                if (!this.isInRange(d)) continue;
                if (nArray[i] == 0 && nArray[j] == 0) {
                    nArray[i] = n2;
                    nArray[j] = n2++;
                    continue;
                }
                if (nArray[i] == 0 && nArray[j] != 0) {
                    nArray[i] = nArray[j];
                    continue;
                }
                if (nArray[i] != 0 && nArray[j] == 0) {
                    nArray[j] = nArray[i];
                    continue;
                }
                if (nArray[i] == nArray[j]) continue;
                for (int k = 0; k < n; ++k) {
                    if (nArray[k] != nArray[j]) continue;
                    nArray[k] = nArray[i];
                }
            }
        }
        return nArray;
    }

    private boolean isInRange(double d) {
        double d2;
        double d3 = 1.0 / Math.pow(10.0, this.precision + 1);
        double d4 = MathUtils.round(d, this.precision);
        return Math.abs(d4 - (d2 = MathUtils.round(this.groupingProximity(), this.precision))) < d3;
    }

    private Dendrogram[] createNewRoots(int[] nArray) {
        Object object;
        LinkedHashMap<Integer, Dendrogram> linkedHashMap = new LinkedHashMap<Integer, Dendrogram>();
        for (int i = 0; i < nArray.length; ++i) {
            Dendrogram dendrogram = this.roots[i];
            if (nArray[i] == 0) {
                dendrogram.setSupercluster(false);
                linkedHashMap.put(-dendrogram.getIdentifier(), dendrogram);
                continue;
            }
            if (linkedHashMap.containsKey(nArray[i])) {
                object = (Dendrogram)linkedHashMap.get(nArray[i]);
                ((Dendrogram)object).addSubcluster(dendrogram);
                continue;
            }
            object = Integer.toString(this.nextClusterId);
            Dendrogram dendrogram2 = new Dendrogram(this.nextClusterId, (String)object, this.isDistanceBased, this.precision);
            ++this.nextClusterId;
            dendrogram2.setRootHeights(this.groupingProximity());
            dendrogram2.setBandsHeights(this.groupingProximity());
            dendrogram2.addSubcluster(dendrogram);
            linkedHashMap.put(nArray[i], dendrogram2);
        }
        Dendrogram[] dendrogramArray = new Dendrogram[linkedHashMap.size()];
        int n = 0;
        object = linkedHashMap.values().iterator();
        while (object.hasNext()) {
            dendrogramArray[n] = (Dendrogram)object.next();
            ++n;
        }
        return dendrogramArray;
    }

    private double groupingProximity() {
        return this.isDistanceBased ? this.rootsMatrix.minimumValue() : this.rootsMatrix.maximumValue();
    }

    private void updateInternalProximities(Dendrogram[] dendrogramArray) {
        for (int i = 0; i < dendrogramArray.length; ++i) {
            Dendrogram dendrogram = dendrogramArray[i];
            int n = dendrogram.numberOfSubroots();
            if (n <= 2) continue;
            double d = this.isDistanceBased ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            for (int j = 0; j < n - 1; ++j) {
                Dendrogram dendrogram2 = dendrogram.getSubroot(j);
                for (int k = j + 1; k < n; ++k) {
                    Dendrogram dendrogram3 = dendrogram.getSubroot(k);
                    double d2 = this.rootsProximity(dendrogram2, dendrogram3);
                    d = this.isDistanceBased ? Math.max(d, d2) : Math.min(d, d2);
                }
            }
            dendrogram.setRootTopHeight(d);
            double d3 = this.calculateInternalProximity(dendrogram);
            dendrogram.setRootInternalHeight(d3);
        }
    }

    private SymmetricMatrix newProximityMatrix(int[] nArray, Dendrogram[] dendrogramArray) {
        int n = dendrogramArray.length;
        SymmetricMatrix symmetricMatrix = new SymmetricMatrix(n);
        for (int i = 0; i < n; ++i) {
            Dendrogram dendrogram = dendrogramArray[i];
            double d = dendrogram.getRootBottomHeight();
            symmetricMatrix.setElement(i, i, d);
            for (int j = i + 1; j < n; ++j) {
                Dendrogram dendrogram2 = dendrogramArray[j];
                d = dendrogram.isSupercluster() || dendrogram2.isSupercluster() ? this.calculateProximity(dendrogram, dendrogram2) : this.rootsProximity(dendrogram, dendrogram2);
                symmetricMatrix.setElement(i, j, d);
            }
        }
        return symmetricMatrix;
    }

    private void mapRootsToIndexes() {
        this.rootsToIndexes = new HashMap();
        for (int i = 0; i < this.roots.length; ++i) {
            Dendrogram dendrogram = this.roots[i];
            this.rootsToIndexes.put(dendrogram.getIdentifier(), i);
        }
    }

    protected double rootsProximity(Dendrogram dendrogram, Dendrogram dendrogram2) {
        int n = this.rootsToIndexes.get(dendrogram.getIdentifier());
        int n2 = this.rootsToIndexes.get(dendrogram2.getIdentifier());
        return this.rootsMatrix.getElement(n, n2);
    }

    protected abstract double calculateProximity(Dendrogram var1, Dendrogram var2);

    protected double minimumProximity(Dendrogram dendrogram, Dendrogram dendrogram2) {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < dendrogram.numberOfSubroots(); ++i) {
            Dendrogram dendrogram3 = dendrogram.getSubroot(i);
            for (int j = 0; j < dendrogram2.numberOfSubroots(); ++j) {
                Dendrogram dendrogram4 = dendrogram2.getSubroot(j);
                double d2 = this.rootsProximity(dendrogram3, dendrogram4);
                d = Math.min(d, d2);
            }
        }
        return d;
    }

    protected double maximumProximity(Dendrogram dendrogram, Dendrogram dendrogram2) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dendrogram.numberOfSubroots(); ++i) {
            Dendrogram dendrogram3 = dendrogram.getSubroot(i);
            for (int j = 0; j < dendrogram2.numberOfSubroots(); ++j) {
                Dendrogram dendrogram4 = dendrogram2.getSubroot(j);
                double d2 = this.rootsProximity(dendrogram3, dendrogram4);
                d = Math.max(d, d2);
            }
        }
        return d;
    }

    protected double calculateInternalProximity(Dendrogram dendrogram) {
        return dendrogram.getRootBottomHeight();
    }

    protected double minimumInternalProximity(Dendrogram dendrogram) {
        double d = Double.POSITIVE_INFINITY;
        int n = dendrogram.numberOfSubroots();
        for (int i = 0; i < n - 1; ++i) {
            Dendrogram dendrogram2 = dendrogram.getSubroot(i);
            for (int j = i + 1; j < n; ++j) {
                Dendrogram dendrogram3 = dendrogram.getSubroot(j);
                double d2 = this.rootsProximity(dendrogram2, dendrogram3);
                d = Math.min(d, d2);
            }
        }
        return d;
    }

    protected double maximumInternalProximity(Dendrogram dendrogram) {
        double d = Double.NEGATIVE_INFINITY;
        int n = dendrogram.numberOfSubroots();
        for (int i = 0; i < n - 1; ++i) {
            Dendrogram dendrogram2 = dendrogram.getSubroot(i);
            for (int j = i + 1; j < n; ++j) {
                Dendrogram dendrogram3 = dendrogram.getSubroot(j);
                double d2 = this.rootsProximity(dendrogram2, dendrogram3);
                d = Math.max(d, d2);
            }
        }
        return d;
    }
}

