% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_as_na.R
\name{recode_as_na}
\alias{recode_as_na}
\title{Recode a value as NA}
\usage{
recode_as_na(
  df,
  value = NULL,
  subset_cols = NULL,
  pattern_type = NULL,
  pattern = NULL,
  case_sensitive = FALSE,
  ...
)
}
\arguments{
\item{df}{A data.frame object for which recoding is to be done.}

\item{value}{The value to convert to `NA`. We can for instance change "n/a" to `NA` or any other value.}

\item{subset_cols}{An optional character vector to define columns for which changes are required.}

\item{pattern_type}{One of contains', 'starts_with' or 'ends_with'.}

\item{pattern}{A character pattern to match}

\item{case_sensitive}{Defaults to FALSE. Patterns are case insensitive if TRUE}

\item{...}{Other arguments to other functions}
}
\value{
An object of the same class as x with values changed to `NA`.
}
\description{
This provides a convenient way to convert a number/value that should indeed be an
"NA" to "NA". In otherwords, it converts a value to R's recognized NA.
}
\examples{
head(recode_as_na(airquality,value=c(67,118),pattern_type="starts_with",pattern="S|O"))
head(recode_as_na(airquality,value=c(41),pattern_type="ends_with",pattern="e"))
head(recode_as_na(airquality, value=41,subset_cols="Ozone"))
}
