% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep.snv}
\alias{prep.snv}
\title{Standard Normal Variate transformation}
\usage{
prep.snv(data)
}
\arguments{
\item{data}{a matrix with data values}
}
\value{
data matrix with processed values
}
\description{
Applies Standard Normal Variate (SNV) transformation to the rows of data matrix
}
\details{
SNV is a simple preprocessing to remove scatter effects (baseline offset and slope) from 
spectral data, e.g. NIR spectra.
 
 @examples
 
 ### Apply SNV to spectra from simdata
 
 library(mdatools)
 data(simdata)
 
 spectra = simdata$spectra.c
 wavelength = simdata$wavelength
 
 cspectra = prep.snv(spectra)
 
 par(mfrow = c(2, 1))
 mdaplot(cbind(wavelength, t(spectra)), type = 'l', main = 'Before SNV')
 mdaplot(cbind(wavelength, t(cspectra)), type = 'l', main = 'After SNV')
}
