% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{setResLimits.pca}
\alias{setResLimits.pca}
\title{Set statistical limits for Q and T2 residuals for PCA model}
\usage{
\method{setResLimits}{pca}(obj, alpha = obj$alpha, gamma = obj$gamma, ...)
}
\arguments{
\item{obj}{object with PCA model}

\item{alpha}{significance level for detection of extreme objects}

\item{gamma}{significance level for detection of outliers (for data driven approach)}

\item{...}{other arguments}
}
\value{
Returns a list with two matrices:  \code{T2lim} and \code{Qlim}. Each matrix contains limits 
for extreme objects and outliers (first two rows), mean residual and degrees of freedom, 
calculated for each number of components included to the model
}
\description{
Computes statisticsl limits for Q and T2 residuals for a PCA model and assing the calculated
values as corresponding model properties
}
\details{
If data driven method is used, first two rows of Qlim and T2lim will contain slope and intercept 
of line defined by the method, otherwise they contain the critical values (first row for extreme
values and second for outliers) for each of the residuals. 

Third row containes average values and fourth row contains degrees of freedom.

See help for \code{\link{pca}} for more details.
}
