% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{getRegcoeffs.pls}
\alias{getRegcoeffs.pls}
\title{Regression coefficients for PLS model'}
\usage{
\method{getRegcoeffs}{pls}(obj, ncomp = NULL, ny = NULL, full = FALSE,
  alpha = obj$coeffs.alpha, ...)
}
\arguments{
\item{obj}{a PLS model (object of class \code{pls})}

\item{ncomp}{number of components to return the coefficients for}

\item{ny}{if y is multivariate which variables you want to see the coefficients for}

\item{full}{if TRUE the method also shows p-values and t-values as well as confidence intervals for the coefficients (if available)}

\item{alpha}{significance level for confidence intervals (a number between 0 and 1, e.g. for 95\% alpha = 0.05)}

\item{...}{other parameters}
}
\value{
A matrix  with regression coefficients and (optinally) statistics.
}
\description{
Returns a matrix with regression coefficients for
the PLS model which can be applied to a data directly
}
\details{
The method recalculates the regression coefficients found by the PLS algorithm
taking into account centering and scaling of predictors and responses, so the 
matrix with coefficients can be applied directly to original data (yp = Xb).

If number of components is not specified, the optimal number, selected by user
or identified by a model will be used.

If Jack-knifing method was used to get statistics for the coefficient the method 
returns all statistics as well (p-value, t-value, confidence interval). In this case user
has to specified a number of y-variable (if there are many) to get the statistics and 
the coefficients for. The confidence interval is computed for unstandardized coefficients.
}
