% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_bias}
\alias{calc_bias}
\title{Calculate Bias and Bias Monte Carlo Standard Error}
\usage{
calc_bias(estimates, true_param)
}
\arguments{
\item{estimates}{A numeric vector of estimates from the simulation or sampling process.}

\item{true_param}{The true parameter value that the estimates are intended to approximate.}
}
\value{
A list with two components: `bias`, the calculated bias of the estimates, and `bias_mcse`,
the Monte Carlo Standard Error of the bias, indicating the uncertainty associated with the bias estimate.
}
\description{
This function computes the bias and the Monte Carlo Standard Error (MCSE) of the bias
for a set of estimates relative to a true parameter value. The bias is the difference
between the mean of the estimates and the true parameter. The MCSE of the bias is calculated
as the square root of the variance of the estimates divided by the number of estimates,
providing a measure of the precision of the bias estimate.
}
\examples{
estimates <- rnorm(100, mean = 50, sd = 10)
true_param <- 50
bias_info <- calc_bias(estimates, true_param)
print(bias_info)
}
