% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_formula.R
\encoding{UTF-8}
\name{get_formula_str}
\alias{get_formula_str}
\title{Build an R formula (as string) given a segment table (ST)}
\usage{
get_formula_str(ST, par_x, ytype = "ct", init = FALSE)
}
\arguments{
\item{ST}{Tibble. Returned by \code{get_segment_table}.}

\item{par_x}{String (default: NULL). Only relevant if no segments contains
slope (no hint at what x is). Set this, e.g., par_x = "time".}

\item{ytype}{One of "ct" (central tendency), "sigma", "ar1" (or another order), or "ma1" (or another order)}

\item{init}{TRUE/FALSE. Set to TRUE for the first call. Adds segment-relative
X-codings and verbose commenting of one formula}
}
\value{
A string with JAGS code.
}
\description{
You will need to replace PAR_X for whatever your x-axis observation column
is called. In JAGS typically \code{x[i_]}. In R just \code{x}.
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
\keyword{internal}
