% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prior.R
\encoding{UTF-8}
\name{get_prior}
\alias{get_prior}
\title{Get priors for all parameters in a segment table.}
\usage{
get_prior(ST, family, prior = list())
}
\arguments{
\item{ST}{Tibble. A segment table returned by \code{get_segment_table}.}

\item{family}{One of \code{gaussian()}, \code{binomial()}, \code{bernoulli()}, or \code{poission()}.
Only default link functions are currently supported.}

\item{prior}{A list of user-defined priors. Will overwrite the relevant
default priors.}
}
\value{
A named list of strings. The names correspond to the parameter names
and the strings are the JAGS code for the prior (before converting SD to
precision).
}
\description{
Starts by finding all default priors. Then replace them with user priors.
User priors for change points are truncated appropriately using
`truncate_prior_cp``, if not done manually by the user already.
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
\keyword{internal}
