% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_jags.R
\encoding{UTF-8}
\name{run_jags}
\alias{run_jags}
\title{Run parallel MCMC sampling using JAGS.}
\usage{
run_jags(
  data,
  jags_code,
  pars,
  ST,
  cores,
  sample,
  n.chains,
  n.iter,
  n.adapt,
  inits
)
}
\arguments{
\item{data}{Data.frame or tibble in long format.}

\item{jags_code}{A string. JAGS model, usually returned by \code{make_jagscode()}.}

\item{pars}{Character vector of parameters to save/monitor.}

\item{ST}{A segment table (tibble), returned by \code{get_segment_table}.
Only really used when the model contains varying effects.}

\item{cores}{Positive integer or "all". Number of cores.
\itemize{
\item \code{1}: serial sampling
\item \verb{>1}: parallel sampling on this number of cores. Ideally set \code{chains}
to the same value. Note: \code{cores > 1} takes a few extra seconds the first
time it's called but subsequent calls will start sampling immediately.
\item \code{"all"}: use all cores but one and sets \code{chains} to the same value. This is
a convenient way to maximally use your computer's power.
}}

\item{sample}{One of
\itemize{
\item \code{"post"} (default): Sample the posterior.
\item \code{"prior"}: Sample only the prior. Plots, summaries, etc. will
use the prior. This is useful for prior predictive checks.
\item \code{"both"}: Sample both prior and posterior. Plots, summaries, etc.
will default to using the posterior. The prior only has effect when doing
Savage-Dickey density ratios in \code{\link{hypothesis}}.
\item \code{"none"} or \code{FALSE}: Do not sample. Returns an mcpfit
object without sample. This is useful if you only want to check
prior strings (fit$prior), the JAGS model (fit$jags_code), etc.
}}

\item{n.chains}{the number of parallel chains for the model}

\item{n.iter}{number of iterations to monitor}

\item{n.adapt}{the number of iterations for adaptation. See 
    \code{\link[rjags]{adapt}} for details. If \code{n.adapt = 0} then no 
    adaptation takes place.}

\item{inits}{A list if initial values for the parameters. This can be useful
if a model fails to converge. Read more in \code{\link[rjags]{jags.model}}.
Defaults to \code{NULL}, i.e., no inits.}
}
\value{
`mcmc.list``
}
\description{
Run parallel MCMC sampling using JAGS.
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
\keyword{internal}
