% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{read_draws}
\alias{read_draws}
\title{Read MCMC draws from a file}
\usage{
read_draws(name, filename = paste0("MCdraws_", name, ".dat"))
}
\arguments{
\item{name}{name of the parameter to load the corresponding file with posterior draws for.}

\item{filename}{name of the file in which the draws are stored.}
}
\value{
An object of class \code{dc} containing MCMC draws for a (vector) parameter.
}
\description{
Read draws written to file by \code{\link{MCMCsim}} used with argument \code{to.file}.
}
\examples{
\dontrun{
# NB this example creates a file "MCdraws_e_.RData" in the working directory
n <- 100
dat <- data.frame(x=runif(n), f=as.factor(sample(1:5, n, replace=TRUE)))
gd <- generate_data(~ reg(~ x + f, prior=pr_normal(precision=1), name="beta"), data=dat)
dat$y <- gd$y
sampler <- create_sampler(y ~ reg(~ x + f, name="beta"), data=dat)
# run the MCMC simulation and write draws of residuals to file:
sim <- MCMCsim(sampler, n.iter=500, to.file="e_")
summary(sim)
mcres <- read_draws("e_")
summary(mcres)
}

}
