% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.R
\name{estimates.mcarray}
\alias{estimates.mcarray}
\title{Estimates}
\usage{
\method{estimates}{mcarray}(x, fun = median, as_df = FALSE, ...)
}
\arguments{
\item{x}{An object.}

\item{fun}{A function that given a numeric vector returns a numeric scalar.}

\item{as_df}{A flag indicating whether to return the values as a
data frame versus a named list.}

\item{...}{Other arguments passed to methods.}
}
\value{
A named list or data frame.
}
\description{
Calculates the estimates for an MCMC object.
}
\examples{
\dontshow{if (requireNamespace("nlist", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlist)

estimates(nlist(x = 1:9))
estimates(nlist(y = 3:5, zz = matrix(1:9, 3)))
estimates(nlists(nlist(x = 1:3), nlist(x = 2:4)), fun = mean)
\dontshow{\}) # examplesIf}
}
\seealso{
Other MCMC manipulations: 
\code{\link[universals]{bind_chains}()},
\code{\link[universals]{collapse_chains}()},
\code{\link[universals]{split_chains}()}
}
