% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_sep.R
\name{..cor_sep}
\alias{..cor_sep}
\title{Calculate correlation for separable model}
\usage{
..cor_sep(nugget, c, gamma = 1/2, a, alpha, h, u)
}
\arguments{
\item{nugget}{The nugget effect \eqn{\in[0, 1]}.}

\item{c}{Scale parameter of \code{cor_exp}, \eqn{c>0}.}

\item{gamma}{Smooth parameter of \code{cor_exp}, \eqn{\gamma\in(0, 1/2]}.}

\item{a}{Scale parameter of \code{cor_cauchy}, \eqn{a>0}.}

\item{alpha}{Smooth parameter of \code{cor_cauchy}, \eqn{\alpha\in(0, 1]}.}

\item{h}{Euclidean distance matrix or array.}

\item{u}{Time lag, same dimension as \code{h}.}
}
\value{
Correlations for separable model.
}
\description{
Calculate correlation for separable model
}
\details{
This function is a special case of \code{\link[=.cor_fs]{.cor_fs()}}. It is used inside
\code{\link[=fit_base]{fit_base()}}.
}
\keyword{internal}
