% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_joint.R
\name{cov_joint}
\alias{cov_joint}
\alias{cov_par}
\title{Covariance for joint distribution}
\usage{
cov_joint(cov)

cov_par(cov, horizon = 1, n_var, joint = FALSE)
}
\arguments{
\item{cov}{Array of covariance matrices.}

\item{horizon}{Forecast horizon, default is 1.}

\item{n_var}{Number of locations.}

\item{joint}{Logical; True if \code{cov} is the joint covariance matrix.}
}
\value{
The joint covariance matrix for the joint distribution of the current
values and the past values for a Markov chain Gaussian field.
}
\description{
Covariance for joint distribution
}
\details{
The covariance matrix of the joint distribution has the block toeplitz
structure. Input \code{cov} is assumed to be an array of cross-covariance matrices
where the \eqn{i}th matrix slice correspond to the \eqn{(i-1)}th time lag.
For example, \code{cov[, , 1]} is the cross-covariance matrix for time lag 0. All
matrices in \code{cov} are used to construct the joint covariance matrix.

\code{cov_par} gives weights and covariance matrix for the current values..
}
\keyword{internal}
