% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{remove_matrix}
\alias{remove_matrix}
\title{Remove one or more matrices of the \code{matrixset} object}
\usage{
remove_matrix(.ms, matrix)
}
\arguments{
\item{.ms}{A \code{matrixset} object. Leave empty only if \code{remove_matrix()}
is used inside \code{mutate_matrix()}.}

\item{matrix}{index specifying matrix or matrices to remove. Index is
\emph{posivie} numeric or character vectors. Tidy select is
also supported .Leave empty only if \code{remove_matrix()}
is used inside \code{mutate_matrix()}.}
}
\value{
A \code{matrixset} with updated matrices.
}
\description{
This is a special case of the \code{[} method, with the benefit of being explicit
about what action is taken.
}
\section{Usage inside \code{\link[=mutate_matrix]{mutate_matrix()}}}{

In most cases, both arguments of the function are mandatory. However, if you
want to declare that a matrix should be removed via the \code{\link[=mutate_matrix]{mutate_matrix()}}
function, the \code{remove_matrix()} must be called without arguments. There is
an example that illustrates that.
}

\examples{
ms1 <- remove_matrix(student_results, "remedial")
ms2 <- remove_matrix(student_results, 2)
ms3 <- mutate_matrix(student_results, remedial = remove_matrix())

}
