% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{znorm}
\alias{znorm}
\alias{ed_corr}
\alias{corr_ed}
\alias{mode}
\alias{std}
\alias{normalize}
\alias{complexity}
\alias{binary_split}
\title{Math Functions}
\usage{
znorm(data, rcpp = TRUE)

ed_corr(data, w, rcpp = TRUE)

corr_ed(data, w, rcpp = TRUE)

mode(x, rcpp = FALSE)

std(data, na.rm = FALSE, rcpp = TRUE)

normalize(data, min_lim = 0, max_lim = 1, rcpp = FALSE)

complexity(data)

binary_split(n, rcpp = TRUE)
}
\arguments{
\item{data}{a \code{vector} of \code{numeric}.}

\item{rcpp}{A \code{logical}. If \code{TRUE} will use the Rcpp implementation, otherwise will use the R implementation,
that may or not be slower.}

\item{w}{the window size}

\item{x}{a \code{vector} of \code{integers}.}

\item{na.rm}{A logical. If \code{TRUE} remove the \code{NA} values from the computation.}

\item{min_lim}{A number}

\item{max_lim}{A number}

\item{n}{size of the vector}
}
\value{
\code{znorm()}: Returns the normalized data

\code{ed_corr()}: Returns the converted values from euclidean distance to correlation values.

\code{corr_ed()}: Returns the converted values from euclidean distance to correlation values.

\code{mode()}: Returns the most common value from a vector of integers.

\code{std()}: Returns the corrected standard deviation from sample to population.

\code{normalize()}: Returns the normalized data between min and max.

\code{complexity()}: Returns the complexity index of the data provided (normally a subset).

\code{complexity()}: Returns a \code{vector} with the binary split indexes.
}
\description{
\code{znorm()}: Normalizes data for mean Zero and Standard Deviation One

\code{ed_corr()}: Converts euclidean distances into correlation values

\code{corr_ed()}: Converts correlation values into euclidean distances

\code{mode()}: Returns the most common value from a vector of integers

\code{std()}: Population SD, as R always calculate with n-1 (sample), here we fix it.

\code{normalize()}: Normalizes data to be between min and max.

\code{complexity()}: Computes the complexity index of the data

\code{binary_split()}: Creates a vector with the indexes of binary split.
}
\examples{
normalized <- znorm(motifs_discords_small)
fake_data <- c(rep(3, 100), rep(2, 100), rep(1, 100))
correlation <- ed_corr(fake_data, 50)
fake_data <- c(rep(0.5, 100), rep(1, 100), rep(0.1, 100))
euclidean <- corr_ed(fake_data, 50)
fake_data <- c(1, 1, 4, 5, 2, 3, 1, 7, 9, 4, 5, 2, 3)
mode <- mode(fake_data)
fake_data <- c(1, 1.4, 4.3, 5.1, 2, 3.6, 1.24, 2, 9, 4.3, 5, 2.1, 3)
res <- std(fake_data)
fake_data <- c(1, 1.4, 4.3, 5.1, 2, 3.6, 1.24, 1, 9, 4.3, 5, 2.1, 3)
res <- normalize(fake_data)
fake_data <- c(1, 1.4, 4.3, 5.1, 2, 3.6, 1.24, 8, 9, 4.3, 5, 2.1, 3)
res <- complexity(fake_data)
fake_data <- c(10)
res <- binary_split(fake_data)
}
