\name{matrixpls.sim}
\alias{matrixpls.sim}
\title{Monte Carlo simulations with matrixpls}
\usage{
  matrixpls.sim(nRep = NULL, model = NULL, n = NULL, ...,
    cilevel = 0.95,
    citype = c("norm", "basic", "stud", "perc", "bca"),
    boot.R = 500, fitIndices = fitSummary)
}
\arguments{
  \item{nRep}{Number of replications. If any of the
  \code{n}, \code{pmMCAR}, or \code{pmMAR} arguments are
  specified as lists, the number of replications will
  default to the length of the list(s), and \code{nRep}
  need not be specified.}

  \item{...}{All other arguments are forwared through to
  \code{\link[simsem]{sim}} or
  \code{\link{matrixpls.boot}}.}

  \item{cilevel}{Confidence level. This argument will be
  forwarded to the \code{\link[boot]{boot.ci}} when
  calculating the confidence intervals.}

  \item{citype}{Type of confidence interval. This argument
  will be forwarded to the \code{\link[boot]{boot.ci}} when
  calculating the confidence intervals.}

  \item{boot.R}{Number of bootstrap replications to use to
  estimate standard errors.}

  \item{fitIndices}{A function that returns a list of fit
  indices for the model. Setting this argument to
  \code{NULL} disables fit indices.}

  \item{model}{There are two options for this argument: 1.
  lavaan script or lavaan parameter table, or 2. a list
  containing three matrices \code{inner},
  \code{reflective}, and \code{formative} defining the free
  regression paths in the model.}

  \item{n}{ Sample size. Either a single value, or a list
  of values to vary sample size across replications. The
  \code{n} argument can also be specified as a random
  distribution object; if any resulting values are
  non-integers, the decimal will be rounded.  }
}
\value{
  An object of class \code{\link[simsem]{SimResult-class}}.
}
\description{
  Performs Monte Carlo simulations of
  \code{\link{matrixpls}} with the
  \code{\link[simsem]{sim}} function of the \code{simsem}
  package. The standard errors and confidence intervals are
  estimated with the \code{\link[boot]{boot}} and
  \code{\link[boot]{boot.ci}} functions of the \code{boot}
  package.
}
\details{
  This funtion calls the \code{\link[simsem]{sim}} function
  from the \code{simsem} package to perform Monte Carlo
  simulations with matrixpls. The function parses the model
  parameters and replaces it with a function call that
  estimates the model and bootstrapped standard errors and
  confidence intervals with \link{matrixpls.boot}.

  If the \code{generate} or \code{rawdata} arguments are
  not specified in the \code{\link[simsem]{sim}} arguments
  then the \code{model} argument will be used for data
  generation and must be specified in lavaan format.
}
\examples{
library(matrixpls)

popModel <- "
f1 =~ 1*y1 + 0.6*y2 + 0.7*y3
f2 =~ 1*y4 + 1.1*y5 + 0.9*y6
f3 =~ 1*y7 + 1.2*y8 + 1.1*y9
f1 ~~ 0.8*f1
f2 ~~ 0.9*f2
f3 ~~ 0.4*f3
f1 ~~ 0.4*f2
f1 ~~ 0.2*f3
f2 ~~ 0.3*f3
y1 ~~ 0.5*y1
y2 ~~ 1.1*y2
y3 ~~ 0.8*y3
y4 ~~ 0.4*y4
y5 ~~ 0.4*y5
y6 ~~ 0.8*y6
y7 ~~ 0.8*y7
y8 ~~ 0.5*y8
y9 ~~ 0.6*y9
"

analyzeModel <- "
f1 =~ y1 + y2 + y3
f2 =~ y4 + y5 + y6
f3 =~ y7 + y8 + y9
"

# Only run 10 replications with 50 bootstrap replications each so that the 
#example runs faster

Output <- matrixpls.sim(10, analyzeModel, n=200, generate=popModel, boot.R=50,
                        multicore = FALSE, stopOnError = TRUE)
getCutoff(Output, 0.05)
plotCutoff(Output, 0.05)
summary(Output)
}
\seealso{
  \code{\link[simsem]{sim}},
  \code{\link[simsem]{SimResult-class}},
  \code{\link{matrixpls.boot}}, \code{\link[boot]{boot}},
  \code{\link[boot]{boot.ci}}
}

