# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Runge-Kutta for the calculation of the a and b vectors and the c matrix in a EM step
#' 
#' Performs the Runge-Kutta method of fourth order.
#' 
#' @param avector The a vector.
#' @param bvector The b vector.
#' @param cmatrix The c matrix.
#' @param dt The increment.
#' @param h Step-length.
#' @param S Sub-intensity matrix.
#' @param s Exit rates.
#' 
runge_kutta <- function(avector, bvector, cmatrix, dt, h, S, s) {
    invisible(.Call(`_matrixdist_runge_kutta`, avector, bvector, cmatrix, dt, h, S, s))
}

#' EM step for phase-type using Runge-Kutta
#' 
#' Computes one step of the EM algorithm by using a Runge-Kutta method of fourth order.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight The weights for the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights for the censored observations.
#' 
EMstep_RK <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    invisible(.Call(`_matrixdist_EMstep_RK`, h, alpha, S, obs, weight, rcens, rcweight))
}

#' Runge-Kutta for the calculation of the a vector in a EM step 
#' 
#' @param avector The a vector.
#' @param dt Increment.
#' @param h Step-length.
#' @param S Sub-intensity matrix.
#' 
a_rungekutta <- function(avector, dt, h, S) {
    invisible(.Call(`_matrixdist_a_rungekutta`, avector, dt, h, S))
}

#' Loglikelihood of phase-type using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodPH_RK <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodPH_RK`, h, alpha, S, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Weibull using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMweibull_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMweibull_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Pareto using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMpareto_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMpareto_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-lognormal using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMlognormal_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMlognormal_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-loglogistic using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameters of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMloglogistic_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Gompertz using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMgompertz_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgompertz_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-GEV using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMgev_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgev_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of PI with phase-type using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodPH_RKs <- function(h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodPH_RKs`, h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-Weibull using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMweibull_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMweibull_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-Pareto using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMpareto_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMpareto_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI matrix-lognormal using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMlognormal_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMlognormal_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-loglogistic using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameters of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMloglogistic_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-Gompertz using Runge-Kutta
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Step-length.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMgompertz_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMgompertz_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Computes the elements S^n / n! until given value of n
#' 
#' @param vect A vector.
#' @param S Sub-intensity matrix.
#' @param vect_size Size of vector.
#' 
vector_of_matrices_2 <- function(vect, S, vect_size) {
    invisible(.Call(`_matrixdist_vector_of_matrices_2`, vect, S, vect_size))
}

#' EM for phase-type distributions using Pade approximation for matrix exponential
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight The weights for the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights for the censored observations.
#' 
EMstep_PADE <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    invisible(.Call(`_matrixdist_EMstep_PADE`, h, alpha, S, obs, weight, rcens, rcweight))
}

#' EM for PH-MoE
#' 
#' No recycling of information
#' 
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight The weights for the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights for the censored observations.
#' 
EMstep_MoE_PADE <- function(alpha, S, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_EMstep_MoE_PADE`, alpha, S, obs, weight, rcens, rcweight)
}

#' EM for bivariate phase-type distributions using Pade for matrix exponential
#'
#' @param alpha Initial probabilities.
#' @param S11 Sub-intensity.
#' @param S12 A matrix.
#' @param S22 Sub-intensity.
#' @param obs The observations.
#' @param weight The weights for the observations.
#' @return Fitted alpha, S11, S12 and S22 after one iteration.
#' 
EMstep_bivph <- function(alpha, S11, S12, S22, obs, weight) {
    invisible(.Call(`_matrixdist_EMstep_bivph`, alpha, S11, S12, S22, obs, weight))
}

#' Loglikelihood for PH-MoE
#' 
#' @param alpha1 Initial probabilities for non-censored data.
#' @param alpha2 Initial probabilities for censored data.
#' @param S Sub-intensity matrix. 
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' 
logLikelihoodPH_MoE <- function(alpha1, alpha2, S, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodPH_MoE`, alpha1, alpha2, S, obs, weight, rcens, rcweight)
}

#' Loglikelihood of phase-type using Pade approximation
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' 
logLikelihoodPH_PADE <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodPH_PADE`, h, alpha, S, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Weibull using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' 
logLikelihoodMweibull_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMweibull_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Pareto using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' 
logLikelihoodMpareto_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMpareto_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-lognormal using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' 
logLikelihoodMlognormal_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMlognormal_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-loglogistic using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' 
logLikelihoodMloglogistic_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Gompertz using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' 
logLikelihoodMgompertz_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgompertz_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-GEV using Pade
#' 
#' Loglikelihood for a sample 
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' 
logLikelihoodMgev_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgev_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of PI with phase-type using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodPH_PADEs <- function(h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodPH_PADEs`, h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-Weibull using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMweibull_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMweibull_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-Pareto using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMpareto_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMpareto_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-lognormal using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMlognormal_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMlognormal_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-loglogistic using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMloglogistic_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-Gompertz using Pade
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Nuisance parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity.
#' @param beta Inhomogeneity parameter.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMgompertz_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMgompertz_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Computes the elements S^n / n! until the a given size
#' 
#' @param vect A vector.
#' @param S Sub-intensity matrix.
#' @param a A number.
#' @param vect_size Size of vector.
#' 
vector_of_matrices <- function(vect, S, a, vect_size) {
    invisible(.Call(`_matrixdist_vector_of_matrices`, vect, S, a, vect_size))
}

#' Computes exp(Sx) via series representation
#' 
#' @param x A number.
#' @param n An integer.
#' @param pow_vector A vector.
#' @param a A number.
#' 
m_exp_sum <- function(x, n, pow_vector, a) {
    .Call(`_matrixdist_m_exp_sum`, x, n, pow_vector, a)
}

#' Computes A^(2^n)
#' 
#' @param n An integer.
#' @param A A matrix.
#' @return A^(2^n).
#' 
pow2_matrix <- function(n, A) {
    invisible(.Call(`_matrixdist_pow2_matrix`, n, A))
}

#' Find n such that P(N > n) = h with N Poisson distributed
#'
#' @param h Probability.
#' @param lambda Mean of Poisson random variable.
#' @return Integer satisfying condition.
#'
find_n <- function(h, lambda) {
    .Call(`_matrixdist_find_n`, h, lambda)
}

#' EM for phase-type using uniformization for matrix exponential
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight The weights for the observations.
#' @param rcens Censored observations.
#' @param rcweight The weights for the censored observations.
#' 
EMstep_UNI <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    invisible(.Call(`_matrixdist_EMstep_UNI`, h, alpha, S, obs, weight, rcens, rcweight))
}

#' Loglikelihood of phase-type using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodPH_UNI <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodPH_UNI`, h, alpha, S, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Weibull using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMweibull_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMweibull_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Pareto using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMpareto_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMpareto_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-lognormal using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMlognormal_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMlognormal_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-loglogistic using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMloglogistic_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Gompertz using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMgompertz_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgompertz_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-GEV using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens censored observations.
#' @param rcweight Weights of the censored observations.
#' 
logLikelihoodMgev_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgev_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of PI with phase-type using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodPH_UNIs <- function(h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodPH_UNIs`, h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-Weibull using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMweibull_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMweibull_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-Pareto using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMpareto_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMpareto_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-lognormal using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMlognormal_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMlognormal_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-loglogistic using uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMloglogistic_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of PI with matrix-Gompertz using Uniformization
#' 
#' Loglikelihood for a sample.
#' 
#' @param h Positive parameter.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of transformation.
#' @param obs The observations.
#' @param weight Weights of the observations.
#' @param rcens Censored observations.
#' @param rcweight Weights of the censored observations.
#' @param scale1 Scale for observations.
#' @param scale2 Scale for censored observations.
#' 
logLikelihoodMgompertz_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMgompertz_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' expm terms of phase-type likelihood using uniformization
#' 
#' @param h Positive parameter.
#' @param S Sub-intensity matrix.
#' @param obs The observations.
#' 
expm_terms <- function(h, S, obs) {
    .Call(`_matrixdist_expm_terms`, h, S, obs)
}

#' Random reward matrix
#'
#' Generates a random reward matrix for a multivariate phase-type distribution 
#' with p states and d marginals.
#'
#' @param p Number of transient states in the sub-intensity matrix.
#' @param d Number of marginals.
#'
#' @return A random reward matrix.
#' @export
random_reward <- function(p, d) {
    .Call(`_matrixdist_random_reward`, p, d)
}

#' Transform a reward matrix with very small rewards to avoid numerical problems
#'
#' @param R Reward matrix
#' @param tol Lower bound considered for a reward
#'
#' @return A reward matrix that does not cause issues with uniformization
#'
rew_sanity_check <- function(R, tol) {
    invisible(.Call(`_matrixdist_rew_sanity_check`, R, tol))
}

#' Marginal conditional expectations
#'
#' @param rew Column of the reward matrix corresponding to its marginal.
#' @param pos Vector that indicates which state is associated to a positive reward.
#' @param N Uniformization parameter.
#' @param obs Marginal observations.
#' @param weight Marginal weights.
#' @param alpha Marginal initial distribution vector.
#' @param S Marginal sub-intensity matrix.
#' 
#' @return A vector with the expected time spent in each state by the marginal, conditional on the observations.
#'
#' @export
marginal_expectation <- function(rew, pos, N, alpha, S, obs, weight) {
    .Call(`_matrixdist_marginal_expectation`, rew, pos, N, alpha, S, obs, weight)
}

#' EM step using Uniformization for MPHstar class
#'
#' @param h positive parameter for precision of uniformization method.
#' @param Rtol The smallest value that a reward can take.
#' @param alpha Vector of initial probabilities of the originating distribution.
#' @param S The sub-intensity matrix of the originating distribution.
#' @param R The reward matrix.
#' @param mph_obs The list of summed, marginal observations  with associated weights.
#'
#' @export
MPHstar_EMstep_UNI <- function(h, Rtol, alpha, S, R, mph_obs) {
    invisible(.Call(`_matrixdist_MPHstar_EMstep_UNI`, h, Rtol, alpha, S, R, mph_obs))
}

#' Embedded Markov chain of a sub-intensity matrix
#' 
#' Returns the transition probabilities of the embedded Markov chain determined
#'  the sub-intensity matrix.
#'  
#' @param S A sub-intensity matrix.
#' @return The embedded Markov chain.
#' 
embedded_mc <- function(S) {
    .Call(`_matrixdist_embedded_mc`, S)
}

#' Cumulate matrix
#'
#' Creates a new matrix with entries the cumulated rows of \code{A}.
#' 
#' @param A A matrix.
#' @return The cumulated matrix.
#'
cumulate_matrix <- function(A) {
    .Call(`_matrixdist_cumulate_matrix`, A)
}

#' Cumulate vector
#'
#' Creates a new vector with entries the cumulated entries of \code{A}.
#' 
#' @param A A vector.
#' @return The cumulated vector.
#'
cumulate_vector <- function(A) {
    .Call(`_matrixdist_cumulate_vector`, A)
}

#' Initial state of Markov jump process
#'
#' Given the accumulated values of the initial probabilities \code{alpha} and a
#'  uniform value \code{u}, it returns the initial state of a Markov jump process.
#' This corresponds to the states satisfying cum_alpha_(k-1) < u < cum_alpha_(k).
#' 
#' @param cum_alpha A cummulated vector of initial probabilities.
#' @param u Random value in (0,1).
#' @return Initial state of the Markov jump process.
#'
initial_state <- function(cum_alpha, u) {
    .Call(`_matrixdist_initial_state`, cum_alpha, u)
}

#' New state in a Markov jump process
#'
#' Given a transition matrix \code{Q}, a uniform value \code{u}, and a previous
#'  state \code{k}, it returns the new state of a Markov jump process.
#'  
#' @param prev_state Previous state of the Markov jump process.
#' @param cum_embedded_mc Transition matrix.
#' @param u Random value in (0,1).
#' @return Next state of the Markov jump process.
#'
new_state <- function(prev_state, cum_embedded_mc, u) {
    .Call(`_matrixdist_new_state`, prev_state, cum_embedded_mc, u)
}

#' Simulate phase-type
#'
#' Generates a sample of size \code{n} from a phase-type distribution with
#' parameters \code{alpha} and \code{S}.
#' 
#' @param n Sample size.
#' @param alpha Vector of initial probabilities.
#' @param S Sub-intensity matrix.
#' @return Simulated sample.
#'
rphasetype <- function(n, alpha, S) {
    .Call(`_matrixdist_rphasetype`, n, alpha, S)
}

#' Random inhomogeneous phase-type
#' 
#' Generates a sample of size \code{n} from an inhomogeneous phase-type 
#' distribution with parameters \code{alpha}, \code{S} and \code{beta}.
#' 
#' @param n Sample size.
#' @param dist_type Type of IPH.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Parameter of the transformation.
#' @return The simulated sample.
#' 
riph <- function(n, dist_type, alpha, S, beta) {
    .Call(`_matrixdist_riph`, n, dist_type, alpha, S, beta)
}

#' Random matrix GEV
#' 
#' Generates a sample of size \code{n} from an inhomogeneous phase-type 
#' distribution with parameters \code{alpha}, \code{S} and \code{beta}.
#' 
#' @param n Sample size.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param mu Location parameter.
#' @param sigma Scale parameter.
#' @param xi Shape parameter: Default 0 which corresponds to the Gumbel case.
#' @return The simulated sample.
#' 
rmatrixgev <- function(n, alpha, S, mu, sigma, xi = 0) {
    .Call(`_matrixdist_rmatrixgev`, n, alpha, S, mu, sigma, xi)
}

#' Simulate discrete phase-type
#'
#' Generates a sample of size \code{n} from a discrete phase-type distribution with
#' parameters \code{alpha} and \code{S}.
#' 
#' @param n Sample size.
#' @param alpha Vector of initial probabilities.
#' @param S Sub-transition matrix.
#' @return Simulated sample.
#'
rdphasetype <- function(n, alpha, S) {
    .Call(`_matrixdist_rdphasetype`, n, alpha, S)
}

#' Simulate a MPH* random vector
#'
#' Generates a sample of size \code{n} from a MPH* distribution with parameters
#'  \code{alpha}, \code{S} and \code{R}.
#'
#' @param n Sample size.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param R Reward matrix.
#' @return The simulated sample.
#' 
rMPHstar <- function(n, alpha, S, R) {
    .Call(`_matrixdist_rMPHstar`, n, alpha, S, R)
}

#' Find how many states have positive reward
#'
#' @param R reward vector
#'
#' @return The number of states with positive rewards
#'
n_pos <- function(R) {
    .Call(`_matrixdist_n_pos`, R)
}

#' Find how many states have null reward
#'
#' @param R reward vector
#'
#' @return The number of states with null rewards
#'
n_null <- function(R) {
    .Call(`_matrixdist_n_null`, R)
}

#' Find which states have positive reward
#'
#' @param R reward vector
#'
#' @return A vector with the states (number) that are associated with positive rewards
#'
plus_states <- function(R) {
    .Call(`_matrixdist_plus_states`, R)
}

#' Find which states have null reward
#'
#' @param R reward vector
#'
#' @return A vector with the states (number) that are associated with null rewards
#'
null_states <- function(R) {
    .Call(`_matrixdist_null_states`, R)
}

#' Obtain Q++
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#'
#' @return The matrix Q++ where we have transition probabilities from/to states associated with positive rewards
#'
Q_pos_pos <- function(R, Qtilda) {
    .Call(`_matrixdist_Q_pos_pos`, R, Qtilda)
}

#' Obtain Q00
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#'
#' @return the matrix Q00 where we have transition probabilities from/to states associated with null rewards
#'
Q_null_null <- function(R, Qtilda) {
    .Call(`_matrixdist_Q_null_null`, R, Qtilda)
}

#' Obtain Qtilda+0
#'
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#'
#' @return the matrix Qtilda+0 where we have transition probabilities from states associated with positive rewards to ones associated with null rewards
#'
Q_pos_null <- function(R, Qtilda) {
    .Call(`_matrixdist_Q_pos_null`, R, Qtilda)
}

#' Obtain Q0+
#'
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#'
#' @return the matrix Q0+ where we have transition probabilities from states associated with null rewards  to ones associated with positive rewards
#'
Q_null_pos <- function(R, Qtilda) {
    .Call(`_matrixdist_Q_null_pos`, R, Qtilda)
}

#' Obtain q+
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#'
#' @return Creates the vector with transition probabilities from states associated with positive rewards to the absorption state
#'
q_pos <- function(R, Qtilda) {
    .Call(`_matrixdist_q_pos`, R, Qtilda)
}

#' Obtain q0
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#'
#' @return Creates the vector with transition probabilities from states associated with null rewards to the absorption state
#'
q_null <- function(R, Qtilda) {
    .Call(`_matrixdist_q_null`, R, Qtilda)
}

#' Obtain new sub-transition matrix for the new embedded MC
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#'
#' @return The sub-transition matrix of the new embedded Markov Chain
#'
new_trans_mat <- function(R, Qtilda) {
    .Call(`_matrixdist_new_trans_mat`, R, Qtilda)
}

#' Obtain new sub-transition exit vector for the new embedded MC
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#'
#' @return The exit rates for the new embedded Markov Chain
#'
new_trans_exit <- function(R, Qtilda) {
    .Call(`_matrixdist_new_trans_exit`, R, Qtilda)
}

#' Get pi+
#'
#' @param R reward vector
#' @param alpha initial distribution vector of the original MJP
#'
#' @return The initial distribution vector for states associated with positive rewards
#'
pi_pos <- function(R, alpha) {
    .Call(`_matrixdist_pi_pos`, R, alpha)
}

#' Get pi0
#'
#' @param R reward vector
#' @param alpha initial distribution vector of the original MJP
#'
#' @return The initial distribution vector for states associated with null rewards
#'
pi_null <- function(R, alpha) {
    .Call(`_matrixdist_pi_null`, R, alpha)
}

#' Obtain new sub-transition matrix for the new embedded MC
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#' @param alpha the original initial distribution vector
#'
#'@return The initial distribution vector for the new Markov Jump Process
#'
new_pi <- function(R, Qtilda, alpha) {
    .Call(`_matrixdist_new_pi`, R, Qtilda, alpha)
}

#' Obtain new exit rate vector for the new embedded MC
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#' @param S original sub-intensity matrix
#'
#' @return The exit rate vector for the new Markov Jump Process
#'
new_exit_vec <- function(R, Qtilda, S) {
    .Call(`_matrixdist_new_exit_vec`, R, Qtilda, S)
}

#' Obtain new sub-intensity matrix for the new MJP
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#' @param S original sub-intensity matrix
#'
#' @return The sub-intensity matrix for the new Markov Jump Process
#'
new_subint_mat <- function(R, Qtilda, S) {
    .Call(`_matrixdist_new_subint_mat`, R, Qtilda, S)
}

#' Performs the TVR
#'
#' @param R reward vector
#' @param Qtilda transition-matrix of the Embedded MC
#' @param alpha initial distribution vector
#' @param S original sub-intensity matrix
#'
#' @return A list of transformed PH distributions
#'
transf_via_rew <- function(R, Qtilda, alpha, S) {
    .Call(`_matrixdist_transf_via_rew`, R, Qtilda, alpha, S)
}

#' Product of two matrices
#' 
#' @param A1 A matrix.
#' @param A2 A matrix.
#' @return Computes A1 * A2.
#' 
matrix_product <- function(A1, A2) {
    .Call(`_matrixdist_matrix_product`, A1, A2)
}

#' Inverse of a matrix
#' 
#' @param A A matrix.
#' @return Inverse of A. 
#' 
matrix_inverse <- function(A) {
    .Call(`_matrixdist_matrix_inverse`, A)
}

#' Phase-type density
#' 
#' Computes the density of a phase-type distribution with parameters
#'  \code{alpha} and \code{S} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @return The density at \code{x}.
#' 
phdensity <- function(x, alpha, S) {
    .Call(`_matrixdist_phdensity`, x, alpha, S)
}

#' Phase-type cdf
#' 
#' Computes the cdf (tail) of a phase-type distribution with parameters 
#'  \code{alpha} and \code{S} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param lower_tail Cdf or tail.
#' @return The cdf (tail) at \code{x}.
#' 
phcdf <- function(x, alpha, S, lower_tail = TRUE) {
    .Call(`_matrixdist_phcdf`, x, alpha, S, lower_tail)
}

#' Matrix-Weibull density
#' 
#' Computes the density of a matrix-Weibull distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Shape parameter.
#' @return The density at \code{x}.
#' 
mweibullden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mweibullden`, x, alpha, S, beta)
}

#' Matrix-Weibull cdf
#' 
#' Computes the cdf (tail) of a matrix-Weibull distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Shape parameter.
#' @param lower_tail Cdf or tail.
#' @return The cdf (tail) at \code{x}.
#' 
mweibullcdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mweibullcdf`, x, alpha, S, beta, lower_tail)
}

#' Matrix-Pareto density
#' 
#' Computes the density of a matrix-Pareto distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Scale parameter.
#' @return The density at \code{x}.
#' 
mparetoden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mparetoden`, x, alpha, S, beta)
}

#' Matrix-Pareto cdf
#' 
#' Computes the cdf (tail) of a matrix-Pareto distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Scale parameter.
#' @param lower_tail Cdf or tail.
#' @return The cdf (tail) at \code{x}.
#' 
mparetocdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mparetocdf`, x, alpha, S, beta, lower_tail)
}

#' Matrix-lognormal density
#' 
#' Computes the density of a matrix-lognormal distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Shape parameter.
#' @return The density at \code{x}.
#' 
mlognormalden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mlognormalden`, x, alpha, S, beta)
}

#' Matrix-lognormal cdf
#' 
#' Computes the cdf (tail) of a matrix-lognormal distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Shape parameter.
#' @param lower_tail Cdf or tail.
#' @return The cdf (tail) at \code{x}.
#' 
mlognormalcdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mlognormalcdf`, x, alpha, S, beta, lower_tail)
}

#' Matrix-loglogistic density
#' 
#' Computes the density of a matrix-loglogistic distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Transformation parameters.
#' @return The density at \code{x}.
#' 
mloglogisticden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mloglogisticden`, x, alpha, S, beta)
}

#' Matrix-loglogistic cdf
#' 
#' Computes the cdf (tail) of a matrix-loglogistic distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Transformation parameters.
#' @param lower_tail Cdf or tail.
#' @return The cdf (tail) at \code{x}.
#' 
mloglogisticcdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mloglogisticcdf`, x, alpha, S, beta, lower_tail)
}

#' Matrix-Gompertz density
#' 
#' Computes the density of a matrix-Gompertz distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Shape parameter.
#' @return The density at \code{x}.
#' 
mgompertzden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mgompertzden`, x, alpha, S, beta)
}

#' Matrix-Gompertz cdf
#' 
#' Computes the cdf (tail) of a matrix-Gompertz distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Shape parameter.
#' @param lower_tail Cdf or tail.
#' @return The cdf (tail) at \code{x}.
#' 
mgompertzcdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mgompertzcdf`, x, alpha, S, beta, lower_tail)
}

#' Matrix-GEV density
#' 
#' Computes the density of a matrix-GEV distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' Does not allow for atoms in zero.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Transformation parameters.
#' @return The density at \code{x}.
#' 
mgevden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mgevden`, x, alpha, S, beta)
}

#' Matrix-GEV cdf
#' 
#' Computes the cdf (tail) of a matrix-GEV distribution with parameters
#'  \code{alpha}, \code{S} and \code{beta} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param beta Transformation parameters. 
#' @param lower_tail Cdf or tail.
#' @return The cdf (tail) at \code{x}.
#' 
mgevcdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mgevcdf`, x, alpha, S, beta, lower_tail)
}

#' Discrete phase-type density
#' 
#' Computes the density of discrete phase-type distribution with parameters
#'  \code{alpha} and \code{S} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-transition matrix.
#' @return The density at \code{x}.
#' 
dphdensity <- function(x, alpha, S) {
    .Call(`_matrixdist_dphdensity`, x, alpha, S)
}

#' Discrete phase-type cdf
#' 
#' Computes the cdf (tail) of a discrete phase-type distribution with parameters 
#'  \code{alpha} and \code{S} at \code{x}.
#' 
#' @param x Non-negative value.
#' @param alpha Initial probabilities.
#' @param S Sub-intensity matrix.
#' @param lower_tail Cdf or tail.
#' @return The cdf (tail) at \code{x}.
#' 
dphcdf <- function(x, alpha, S, lower_tail = TRUE) {
    .Call(`_matrixdist_dphcdf`, x, alpha, S, lower_tail)
}

#' Bivariate phase-type joint density of the feed forward type
#'
#' @param x Matrix of values.
#' @param alpha Vector of initial probabilities.
#' @param S11 Sub-intensity matrix.
#' @param S12 Matrix.
#' @param S22 Sub-intensity matrix.
#' @return Joint density at \code{x}.
#' 
bivph_density <- function(x, alpha, S11, S12, S22) {
    .Call(`_matrixdist_bivph_density`, x, alpha, S11, S12, S22)
}

#' Bivariate phase-type joint tail of the feed forward type
#'
#' @param x Matrix of values.
#' @param alpha Vector of initial probabilities.
#' @param S11 Sub-intensity matrix.
#' @param S12 Matrix.
#' @param S22 Sub-intensity matrix.
#' @return Joint tail at \code{x}.
#' 
bivph_tail <- function(x, alpha, S11, S12, S22) {
    .Call(`_matrixdist_bivph_tail`, x, alpha, S11, S12, S22)
}

#' EM for discrete phase-type
#' 
#' @param alpha Initial probabilities.
#' @param S Sub-transition matrix.
#' @param obs The observations.
#' @param weight The weights for the observations.
#' 
EMstep_dph <- function(alpha, S, obs, weight) {
    invisible(.Call(`_matrixdist_EMstep_dph`, alpha, S, obs, weight))
}

#' EM for discrete phase-type MoE
#' 
#' @param alpha Initial probabilities.
#' @param S Sub-transition matrix.
#' @param obs The observations.
#' @param weight The weights for the observations.
#' 
EMstep_dph_MoE <- function(alpha, S, obs, weight) {
    .Call(`_matrixdist_EMstep_dph_MoE`, alpha, S, obs, weight)
}

#' Loglikelihood for discrete phase-type
#' 
#' @param alpha Initial probabilities.
#' @param S Sub-transition matrix.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' 
logLikelihoodDPH <- function(alpha, S, obs, weight) {
    .Call(`_matrixdist_logLikelihoodDPH`, alpha, S, obs, weight)
}

#' Loglikelihood for discrete phase-type MoE
#' 
#' @param alpha Initial probabilities.
#' @param S Sub-transition matrix.
#' @param obs The observations.
#' @param weight The weights of the observations.
#' 
logLikelihoodDPH_MoE <- function(alpha, S, obs, weight) {
    .Call(`_matrixdist_logLikelihoodDPH_MoE`, alpha, S, obs, weight)
}

#' EM step for the mPH class with right-censoring, for different marginal 
#'  sub-intensity matrices
#'
#' @param alpha Common initial distribution vector.
#' @param S_list List of marginal sub-intensity matrices.
#' @param y Matrix of marginal observations.
#' @param delta Matrix with right-censoring indications (1 uncensored, 0 right-censored).
#' @param h Tolerance of uniformization.
#'
EM_step_mPH_rc <- function(alpha, S_list, y, delta, h) {
    invisible(.Call(`_matrixdist_EM_step_mPH_rc`, alpha, S_list, y, delta, h))
}

#' L inf norm of a matrix
#' 
#' Computes the L inf norm of a matrix \code{A}, which is defined as:
#' L_inf(A) =  max(1 <= i <= M) sum(1 <= j <= N) abs(A(i,j)).
#' 
#' @param A A matrix.
#' @return The L inf norm.
#' 
inf_norm <- function(A) {
    .Call(`_matrixdist_inf_norm`, A)
}

#' Creates the matrix  (A1, B1 ; 0, A2)
#' 
#' @param A1 Matrix.
#' @param A2 Matrix.
#' @param B1 Matrix.
#' @return Computes (A1, B1 ; 0, A2).
#' 
matrix_vanloan <- function(A1, A2, B1) {
    .Call(`_matrixdist_matrix_vanloan`, A1, A2, B1)
}

#' Maximum diagonal element of a matrix
#' 
#' @param A Matrix.
#' @return The maximum value in the diagonal.
#' 
max_diagonal <- function(A) {
    .Call(`_matrixdist_max_diagonal`, A)
}

#' Matrix exponential
#' 
#' MATLAB's built-in algorithm for matrix exponential - Pade approximation.
#' 
#' @param A A matrix.
#' @return exp(A).
#' 
matrix_exponential <- function(A) {
    .Call(`_matrixdist_matrix_exponential`, A)
}

#' Matrix exponential
#' 
#' Armadillo matrix exponential implementation.
#' 
#' @param A A matrix.
#' @return exp(A).
#' 
expmat <- function(A) {
    .Call(`_matrixdist_expmat`, A)
}

#' Computes A^n
#'
#' @param A A matrix.
#' @param n An integer.
#' @return A^n.
#' @export
matrix_power <- function(n, A) {
    .Call(`_matrixdist_matrix_power`, n, A)
}

#' Computes elements A^n until the given size
#'
#' @param A A matrix.
#' @param vect_size Size of vector.
#'
vector_of_powers <- function(A, vect_size) {
    .Call(`_matrixdist_vector_of_powers`, A, vect_size)
}

#' Default size of the steps in the RK
#' 
#' Computes the default step length for a matrix \code{S} to be employed in the
#'  RK method.
#'  
#' @param S Sub-intensity matrix.
#' @return The step length for \code{S}.
#' 
default_step_length <- function(S) {
    .Call(`_matrixdist_default_step_length`, S)
}

#' Applies the inverse of the GEV transformation but giving back the resulting 
#'  vector in reverse order
#' 
#' Used for EM step in RK.
#' 
#' @param obs The observations.
#' @param weights Weights of the observations.
#' @param beta Parameters of the GEV.
#' 
revers_data_trans <- function(obs, weights, beta) {
    .Call(`_matrixdist_revers_data_trans`, obs, weights, beta)
}

#' Clone a vector 
#' 
#' @param v A vector.
#' @return A clone of the vector.
#' 
clone_vector <- function(v) {
    .Call(`_matrixdist_clone_vector`, v)
}

#' Clone a matrix 
#' 
#' @param m A matrix.
#' @return A clone of the matrix.
#' 
clone_matrix <- function(m) {
    .Call(`_matrixdist_clone_matrix`, m)
}

#' Computes the initial distribution and sub-intensity of the sum of two 
#'  phase-type distributed random variables. 
#' 
#' @param alpha1 Initial distribution.
#' @param S1 Sub-intensity matrix.
#' @param alpha2 Initial distribution.
#' @param S2 Sub-intensity matrix.
#' 
sum_ph <- function(alpha1, S1, alpha2, S2) {
    .Call(`_matrixdist_sum_ph`, alpha1, S1, alpha2, S2)
}

#' Computes the initial distribution and sub-intensity of the sum of two 
#'  discrete phase-type distributed random variables
#' 
#' @param alpha1 Initial distribution.
#' @param S1 Sub-transition matrix.
#' @param alpha2 Initial distribution.
#' @param S2 Sub-transition matrix.
#' 
sum_dph <- function(alpha1, S1, alpha2, S2) {
    .Call(`_matrixdist_sum_dph`, alpha1, S1, alpha2, S2)
}

#' Random structure of a phase-type
#' 
#' Generates random parameters \code{alpha} and \code{S} of a phase-type 
#'  distribution of dimension \code{p} with chosen structure.
#'  
#' @param p Dimension of the phase-type.
#' @param structure Type of structure: "general", "hyperexponential", "gerlang",
#'  "coxian" or "gcoxian".
#' @param scale_factor A factor that multiplies the sub-intensity matrix.
#' @return Random parameters \code{alpha} and \code{S} of a phase-type.
#' 
random_structure <- function(p, structure = "general", scale_factor = 1) {
    .Call(`_matrixdist_random_structure`, p, structure, scale_factor)
}

#' Random structure of a bivariate phase-type
#'
#' Generates random parameters \code{alpha}, \code{S11}, \code{S12}, and \code{S22}
#' of a bivariate phase-type distribution of dimension \code{p  = p1 + p2}.
#'
#' @param p1 Dimension of the first block.
#' @param p2 Dimension of the second block.
#' @param scale_factor A factor that multiplies the sub-intensity matrix.
#' @return Random parameters  \code{alpha}, \code{S11}, \code{S12}, and \code{S22}
#'  of a bivariate phase-type.
#'
random_structure_bivph <- function(p1, p2, scale_factor = 1) {
    .Call(`_matrixdist_random_structure_bivph`, p1, p2, scale_factor)
}

#' Merges the matrices S11, S12 and S22 into a sub-intensity matrix
#'
#' @param S11 A sub-intensity matrix.
#' @param S12 A matrix.
#' @param S22 A sub-intensity matrix.
#' @return A sub-intensity matrix.
#'
merge_matrices <- function(S11, S12, S22) {
    .Call(`_matrixdist_merge_matrices`, S11, S12, S22)
}

