% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.ph.R
\name{fit,ph-method}
\alias{fit,ph-method}
\title{Fit Method for ph Class}
\usage{
\S4method{fit}{ph}(
  x,
  y,
  weight = numeric(0),
  rcen = numeric(0),
  rcenweight = numeric(0),
  stepsEM = 1000,
  rkstep = NA,
  maxit = 100,
  reltol = 1e-08,
  every = 100
)
}
\arguments{
\item{x}{an object of class \linkS4class{ph}.}

\item{y}{vector or data.}

\item{weight}{vector of weights.}

\item{rcen}{vector of right-censored observations}

\item{rcenweight}{vector of weights for right-censored observations.}

\item{stepsEM}{number of EM steps to be performed.}

\item{rkstep}{Runge-Kutta step size (optional)}

\item{maxit}{maximum number of iterations when optimizing g function.}

\item{reltol}{relative tolerance when optimizing g function.}

\item{every}{number of iterations between likelihood display updates.}
}
\value{
An object of class \linkS4class{ph}.
}
\description{
Fit Method for ph Class
}
\examples{
obj <- iph(ph(structure = "general", dimension = 2), gfun = "weibull", gfun_pars = 2)
data <- sim(obj, n = 100)
fit(obj, data, stepsEM = 1000, every = 200)
}
