library("matrixStats")

set.seed(1)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Benchmarking
# - - - - - - - - - - - - - - - - - - - - - - - - - - - -
cat("Benchmarking:\n")

# Simulate data in a matrix of any shape
nrow <- 1000
ncol <- 1000
x <- rnorm(nrow*ncol)
dim(x) <- c(nrow, ncol)
probs <- 0.3
which <- round(probs*ncol)
gc()
t0 <- system.time({
  for (rr in 1:5)
    y0 <- apply(x, MARGIN=1, FUN=quantile, probs=probs, type=3)
})
gc()
t1 <- system.time({
  for (rr in 1:5)
    y1 <- rowOrderStats(x, which=which)
})
stopifnot(all.equal(y0,y1))
cat(sprintf("rowOrderStats()/apply(): %.3g\n", (t1/t0)[3]))


# - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Consistency checks
# - - - - - - - - - - - - - - - - - - - - - - - - - - - -
cat("Consistency checks without NAs:\n")
for (kk in 1:5) {
  cat("Random test #", kk, "\n", sep="")

  # Simulate data in a matrix of any shape
  nrow <- sample(1000, size=1)
  ncol <- sample(1000, size=1)
  x <- rnorm(nrow*ncol)
  dim(x) <- c(nrow, ncol)

  probs <- runif(1)
  which <- round(probs*ncol)

  t0 <- system.time({
    y0 <- apply(x, MARGIN=1, FUN=quantile, probs=probs, type=3)
  })
  t1 <- system.time({
    y1 <- rowOrderStats(x, which=which)
  })
  stopifnot(all.equal(y0,y1))
} # for (kk in ...)
