% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_method.R
\name{power_method}
\alias{power_method}
\title{Power Method for Eigenvectors}
\usage{
power_method(X, v = NULL, eps = 1e-06, maxiter = 100, verbose = FALSE)
}
\arguments{
\item{X}{a square numeric matrix}

\item{v}{optional starting vector}

\item{eps}{convergence threshold}

\item{maxiter}{maximum number of iterations}

\item{verbose}{logical; if \code{TRUE}, show the approximation to the eigenvector at each iteration}
}
\value{
a list containing the eigenvector, eigenvalue, and iterations
}
\description{
Finds a dominant eigenvalue and its corresponding
eigenvector of a square matrix by applying the Power Method with scaling
}
\examples{
A = cbind(c(2, 1), c(12, 5))
power_method(A)
eigen(A)$vectors[,1]  # check

B = cbind(c(1, 2, 0), c(2, 1, 3), c(0, 3, 1))
power_method(B)
}
\author{
Gaston Sanchez (from matrixkit)
}

