% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporalDataFunctions.R
\name{synchrony}
\alias{synchrony}
\title{Make potentials object--mating synchrony}
\usage{
synchrony(scene, method, subject = "all", averageType = "mean",
  syncNN = 1, compareToSelf = FALSE)
}
\arguments{
\item{scene}{a matingScene object that includes the flowering schedule for the
scene of interest.}

\item{method}{character, partial matching allowed, describing what type
of synchrony will be calculated. "augspurger" is based on the method
described in Augspurger (1983). "kempenaers" is based on the method
described in Kempenaers (1993). "sync_prop" will calculate individual
 synchrony based on the proportion of the sum of all individuals' days
 available to mate that coincided with the individual's days available for mating.
"overlap" will calculate a synchrony value based on the number of days both
individuals were flowering divided by the number of days either individual
was available for mating. "sync_nn" gives the average of the kth nearest
neighbor, or rather the kth most synchronous individual.}

\item{subject}{one of "population", "pairwise", "individual", or "all"
- see Value for more details.}

\item{averageType}{character. Identifies whether to take the mean or median
when calculating averages}

\item{syncNN}{integer. The kth nearest neighbor to be averaged when
calculating population synchrony}

\item{compareToSelf}{logical. Whether or not to include self comparisons
when calculation synchrony. Defaults to FALSE.}
}
\value{
A potentials object containing one more more of the following, depending the
input for \code{subject}: \cr
If \code{subject} is "population" \code{synchrony} will return a numeric
value that has a range depending on the \code{method}. If
\code{subject} is "pairwise" \code{synchrony} will return a matrix
with all pairwise synchrony comparisons. It is important to note two things:
[1] if \code{method} is set to "sync_nn" then the pairwise comparisons will
be in descending order and cannot be indexed by ID order. [2] if
\code{compareToSelf} is set to FALSE, the matrix will have dimensions 100
rows by 99 columns. Similar to \code{\link{overlap}}, indexing will be
affected. If \code{subject} is "individual" \code{synchrony} will
returns a data frame with a row for id and a row for individual synchrony.
If \code{subject} is "all" \code{synchrony} will return a list
containing the values described above for population, pairwise, and
individual synchrony.
}
\description{
Calculate one of a variety of measures of mating synchrony.
}
\details{
Measures of synchrony are based on methods described in Augspurger (1983),
Kempenaers (1983), and from Ison and Wagenius (2014), as well
as variations on different factors of those measures.
}
\examples{
pop <- simulateScene(size = 150)
synchrony(pop, "augs")

pop2 <- simulateScene(size = 1234, sdDur = 5, sk = 1)
syncVals <- synchrony(pop2, "sync_nn", "all", "median", 123)
}
\author{
Danny Hanson
}
\references{
Kempenaers, B. (1993) The use of a breeding synchrony index.
\emph{Ornis Scandinavica}, \strong{24}, 1. \cr\cr
Augspurger, C.K. (1983) Phenology, flowering synchrony, and fruit set of
six neotropical shrubs. \emph{Biotropica} \strong{15}, 257-267.
}

