/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.integer.extension;

import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.extension.IterLargeRelation;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.constraints.integer.extension.TuplesList;
import java.util.List;

public class IterTuplesTable
extends TuplesList
implements IterLargeRelation,
LargeRelation {
    protected int[][][] table;
    protected int nbVar = 0;
    protected int[] dsizes;
    protected int[] offsets;

    public IterTuplesTable(List<int[]> tuples, int[] offsets, int[] domSizes) {
        super(tuples);
        this.nbVar = domSizes.length;
        this.dsizes = domSizes;
        this.offsets = offsets;
        this.table = new int[this.nbVar][][];
        for (int i = 0; i < domSizes.length; ++i) {
            this.table[i] = new int[domSizes[i]][];
            int[] nbsups = this.getNbSupportFor(tuples, i);
            for (int j = 0; j < nbsups.length; ++j) {
                this.table[i][j] = new int[nbsups[j]];
            }
        }
        this.buildInitialListOfSupports(tuples);
    }

    public int[] getNbSupportFor(List<int[]> tups, int i) {
        int[] nbsup = new int[this.dsizes[i]];
        for (int[] tuple : tups) {
            int n = tuple[i] - this.offsets[i];
            nbsup[n] = nbsup[n] + 1;
        }
        return nbsup;
    }

    public void buildInitialListOfSupports(List<int[]> tuples) {
        int cpt = 0;
        int[][] level = new int[this.nbVar][];
        for (int i = 0; i < this.nbVar; ++i) {
            level[i] = new int[this.dsizes[i]];
        }
        for (int[] tuple : tuples) {
            for (int i = 0; i < tuple.length; ++i) {
                int value = tuple[i] - this.offsets[i];
                this.table[i][value][level[i][value]] = cpt;
                int[] nArray = level[i];
                int n = value;
                nArray[n] = nArray[n] + 1;
            }
            ++cpt;
        }
    }

    public int[][][] getTableLists() {
        return this.table;
    }

    @Override
    public int seekNextTuple(int oldidx, int var, int val) {
        int nidx;
        if ((nidx = oldidx++) < this.table[var][val].length) {
            return this.table[var][val][nidx];
        }
        return -1;
    }

    @Override
    public int getNbSupport(int var, int val) {
        return this.table[var][val].length;
    }

    public int getRelationOffset(int var) {
        return this.offsets[var];
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        throw new SolverException("checkTuple should not be used on an IterRelation");
    }

    @Override
    public boolean isConsistent(int[] tuple) {
        return this.checkTuple(tuple);
    }
}

