/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.objective;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solution;
import choco.kernel.solver.search.IObjectiveManager;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class IntObjectiveManager
implements IObjectiveManager {
    public final IntDomainVar objective;
    protected int bound;
    protected int floorBound;
    protected int targetBound;

    public IntObjectiveManager(IntDomainVar objective) {
        this.objective = objective;
    }

    public abstract int getInitialBoundValue();

    public abstract int getFloorValue();

    public abstract int getCeilValue();

    @Override
    public final Var getObjective() {
        return this.objective;
    }

    @Override
    public final Number getObjectiveValue() {
        return this.getFloorValue();
    }

    @Override
    public final Number getBestObjectiveValue() {
        return this.bound;
    }

    @Override
    public final Number getObjectiveTarget() {
        return this.targetBound;
    }

    @Override
    public final Number getObjectiveFloor() {
        return this.floorBound;
    }

    @Override
    public final void initBounds() {
        this.bound = this.getInitialBoundValue();
        this.floorBound = this.getFloorValue();
        this.targetBound = this.getCeilValue();
    }

    @Override
    public final void postIncFloorBound() throws ContradictionException {
        this.objective.setVal(this.floorBound);
    }

    @Override
    public final void writeObjective(Solution sol) {
        sol.recordIntObjective(this.getFloorValue());
    }

    public String toString() {
        return this.objective.pretty();
    }
}

